/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.MapMaker;
import com.google.common.io.ByteStreams;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.core.apis.handles.ArrayByteChannel;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.shared.util.IoUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public final class ResourceMount
implements IMount {
    private static final int MAX_CACHED_SIZE = 0x100000;
    private static final int MAX_CACHE_SIZE = 0x4000000;
    private static final byte[] TEMP_BUFFER = new byte[8192];
    private static final Cache<FileEntry, byte[]> CONTENTS_CACHE = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterAccess(60L, TimeUnit.SECONDS).maximumWeight(0x4000000L).weakKeys().weigher((k, v) -> ((byte[])v).length).build();
    private static final MapMaker CACHE_TEMPLATE = new MapMaker().weakValues().concurrencyLevel(1);
    private static final Map<IReloadableResourceManager, Map<ResourceLocation, ResourceMount>> MOUNT_CACHE = new WeakHashMap<IReloadableResourceManager, Map<ResourceLocation, ResourceMount>>(2);
    private final String namespace;
    private final String subPath;
    private final IReloadableResourceManager manager;
    @Nullable
    private FileEntry root;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceMount get(String namespace, String subPath, IReloadableResourceManager manager) {
        ConcurrentMap cache;
        Map<IReloadableResourceManager, Map<ResourceLocation, ResourceMount>> map = MOUNT_CACHE;
        synchronized (map) {
            cache = MOUNT_CACHE.get(manager);
            if (cache == null) {
                cache = CACHE_TEMPLATE.makeMap();
                MOUNT_CACHE.put(manager, cache);
            }
        }
        ResourceLocation path = new ResourceLocation(namespace, subPath);
        ConcurrentMap concurrentMap = cache;
        synchronized (concurrentMap) {
            ResourceMount mount = (ResourceMount)cache.get(path);
            if (mount == null) {
                mount = new ResourceMount(namespace, subPath, manager);
                cache.put(path, mount);
            }
            return mount;
        }
    }

    private ResourceMount(String namespace, String subPath, IReloadableResourceManager manager) {
        this.namespace = namespace;
        this.subPath = subPath;
        this.manager = manager;
        Listener.INSTANCE.add(manager, this);
        if (this.root == null) {
            this.load();
        }
    }

    private void load() {
        boolean hasAny = false;
        String existingNamespace = null;
        FileEntry newRoot = new FileEntry(new ResourceLocation(this.namespace, this.subPath));
        for (ResourceLocation file : this.manager.func_199003_a(this.subPath, s -> true)) {
            existingNamespace = file.func_110624_b();
            if (!file.func_110624_b().equals(this.namespace)) continue;
            String localPath = FileSystem.toLocal(file.func_110623_a(), this.subPath);
            this.create(newRoot, localPath);
            hasAny = true;
        }
        FileEntry fileEntry = this.root = hasAny ? newRoot : null;
        if (!hasAny) {
            ComputerCraft.log.warn("Cannot find any files under /data/{}/{} for resource mount.", (Object)this.namespace, (Object)this.subPath);
            if (existingNamespace != null) {
                ComputerCraft.log.warn("There are files under /data/{}/{} though. Did you get the wrong namespace?", (Object)existingNamespace, (Object)this.subPath);
            }
        }
    }

    private FileEntry get(String path) {
        FileEntry lastEntry = this.root;
        int lastIndex = 0;
        while (lastEntry != null && lastIndex < path.length()) {
            int nextIndex = path.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = path.length();
            }
            lastEntry = lastEntry.children == null ? null : lastEntry.children.get(path.substring(lastIndex, nextIndex));
            lastIndex = nextIndex + 1;
        }
        return lastEntry;
    }

    private void create(FileEntry lastEntry, String path) {
        int lastIndex = 0;
        while (lastIndex < path.length()) {
            FileEntry nextEntry;
            int nextIndex = path.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = path.length();
            }
            String part = path.substring(lastIndex, nextIndex);
            if (lastEntry.children == null) {
                lastEntry.children = new HashMap<String, FileEntry>();
            }
            if ((nextEntry = lastEntry.children.get(part)) == null) {
                ResourceLocation childPath;
                try {
                    childPath = new ResourceLocation(this.namespace, this.subPath + "/" + path);
                }
                catch (ResourceLocationException e) {
                    ComputerCraft.log.warn("Cannot create resource location for {} ({})", (Object)part, (Object)e.getMessage());
                    return;
                }
                nextEntry = new FileEntry(childPath);
                lastEntry.children.put(part, nextEntry);
            }
            lastEntry = nextEntry;
            lastIndex = nextIndex + 1;
        }
    }

    @Override
    public boolean exists(@Nonnull String path) {
        return this.get(path) != null;
    }

    @Override
    public boolean isDirectory(@Nonnull String path) {
        FileEntry file = this.get(path);
        return file != null && file.isDirectory();
    }

    @Override
    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        FileEntry file = this.get(path);
        if (file == null || !file.isDirectory()) {
            throw new IOException("/" + path + ": Not a directory");
        }
        file.list(contents);
    }

    @Override
    public long getSize(@Nonnull String path) throws IOException {
        FileEntry file = this.get(path);
        if (file != null) {
            if (file.size != -1L) {
                return file.size;
            }
            if (file.isDirectory()) {
                file.size = 0L;
                return 0L;
            }
            byte[] contents = (byte[])CONTENTS_CACHE.getIfPresent((Object)file);
            if (contents != null) {
                file.size = contents.length;
                return file.size;
            }
            try {
                IResource resource = this.manager.func_199002_a(file.identifier);
                InputStream s = resource.func_199027_b();
                int total = 0;
                int read = 0;
                do {
                    total += read;
                } while ((read = s.read(TEMP_BUFFER)) > 0);
                file.size = total;
                return file.size;
            }
            catch (IOException e) {
                file.size = 0L;
                return 0L;
            }
        }
        throw new IOException("/" + path + ": No such file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ReadableByteChannel openForRead(@Nonnull String path) throws IOException {
        FileEntry file = this.get(path);
        if (file != null && !file.isDirectory()) {
            byte[] contents = (byte[])CONTENTS_CACHE.getIfPresent((Object)file);
            if (contents != null) {
                return new ArrayByteChannel(contents);
            }
            try {
                InputStream stream = this.manager.func_199002_a(file.identifier).func_199027_b();
                if (stream.available() > 0x100000) {
                    return Channels.newChannel(stream);
                }
                try {
                    contents = ByteStreams.toByteArray((InputStream)stream);
                }
                finally {
                    IoUtil.closeQuietly(stream);
                }
                CONTENTS_CACHE.put((Object)file, (Object)contents);
                return new ArrayByteChannel(contents);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        throw new IOException("/" + path + ": No such file");
    }

    static class Listener
    implements ISelectiveResourceReloadListener {
        private static final Listener INSTANCE = new Listener();
        private final Set<ResourceMount> mounts = Collections.newSetFromMap(new WeakHashMap());
        private final Set<IReloadableResourceManager> managers = Collections.newSetFromMap(new WeakHashMap());

        Listener() {
        }

        public void func_195410_a(@Nonnull IResourceManager manager) {
            this.onResourceManagerReload(manager, x -> true);
        }

        public synchronized void onResourceManagerReload(@Nonnull IResourceManager manager, @Nonnull Predicate<IResourceType> predicate) {
            for (ResourceMount mount : this.mounts) {
                mount.load();
            }
        }

        synchronized void add(IReloadableResourceManager manager, ResourceMount mount) {
            if (this.managers.add(manager)) {
                manager.func_219534_a((IFutureReloadListener)this);
            }
            this.mounts.add(mount);
        }
    }

    private static class FileEntry {
        final ResourceLocation identifier;
        Map<String, FileEntry> children;
        long size = -1L;

        FileEntry(ResourceLocation identifier) {
            this.identifier = identifier;
        }

        boolean isDirectory() {
            return this.children != null;
        }

        void list(List<String> contents) {
            if (this.children != null) {
                contents.addAll(this.children.keySet());
            }
        }
    }
}

