/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.tracking;

import com.google.common.base.CaseFormat;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.tracking.Tracker;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.core.tracking.TrackingField;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.minecraft.util.text.LanguageMap;

public final class ComputerMBean
implements DynamicMBean,
Tracker {
    private static final Set<TrackingField> SKIP = new HashSet<TrackingField>(Arrays.asList(TrackingField.TASKS, TrackingField.TOTAL_TIME, TrackingField.AVERAGE_TIME, TrackingField.MAX_TIME, TrackingField.SERVER_COUNT, TrackingField.SERVER_TIME));
    private static ComputerMBean instance;
    private final Map<String, LongSupplier> attributes = new HashMap<String, LongSupplier>();
    private final Map<TrackingField, Counter> values = new HashMap<TrackingField, Counter>();
    private final MBeanInfo info;

    private ComputerMBean() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<String, TrackingField> field : TrackingField.fields().entrySet()) {
            if (SKIP.contains(field.getValue())) continue;
            String name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getKey());
            this.add(name, field.getValue(), attributes, null);
        }
        this.add("task", TrackingField.TOTAL_TIME, attributes, TrackingField.TASKS);
        this.add("serverTask", TrackingField.SERVER_TIME, attributes, TrackingField.SERVER_COUNT);
        this.info = new MBeanInfo(ComputerMBean.class.getSimpleName(), "metrics about all computers on the server", attributes.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    public static void register() {
        try {
            instance = new ComputerMBean();
            ManagementFactory.getPlatformMBeanServer().registerMBean(instance, new ObjectName("dan200.computercraft:type=Computers"));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            ComputerCraft.log.warn("Failed to register JMX bean", (Throwable)e);
        }
    }

    public static void registerTracker() {
        if (instance != null) {
            Tracking.add(instance);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        LongSupplier value = this.attributes.get(attribute);
        if (value == null) {
            throw new AttributeNotFoundException();
        }
        return value.getAsLong();
    }

    @Override
    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException {
        throw new InvalidAttributeValueException("Cannot set attribute");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    @Nonnull
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public void addTaskTiming(Computer computer, long time) {
        this.addValue(computer, TrackingField.TOTAL_TIME, time);
    }

    @Override
    public void addServerTiming(Computer computer, long time) {
        this.addValue(computer, TrackingField.SERVER_TIME, time);
    }

    @Override
    public void addValue(Computer computer, TrackingField field, long change) {
        Counter counter = this.values.get(field);
        counter.value.addAndGet(change);
        counter.count.incrementAndGet();
    }

    private MBeanAttributeInfo addAttribute(String name, String description, LongSupplier value) {
        this.attributes.put(name, value);
        return new MBeanAttributeInfo(name, "long", description, true, false, false);
    }

    private void add(String name, TrackingField field, List<MBeanAttributeInfo> attributes, TrackingField count) {
        Counter counter = new Counter();
        this.values.put(field, counter);
        String prettyName = LanguageMap.func_74808_a().func_230503_a_(field.translationKey());
        attributes.add(this.addAttribute(name, prettyName, counter.value::longValue));
        if (count != null) {
            String countName = LanguageMap.func_74808_a().func_230503_a_(count.translationKey());
            attributes.add(this.addAttribute(name + "Count", countName, counter.count::longValue));
        }
    }

    private static class Counter {
        AtomicLong value = new AtomicLong();
        AtomicLong count = new AtomicLong();

        private Counter() {
        }
    }
}

