/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.util.IoUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;

public class TerminalState {
    public final boolean colour;
    public final int width;
    public final int height;
    private final boolean compress;
    @Nullable
    private final ByteBuf buffer;
    private ByteBuf compressed;

    public TerminalState(boolean colour, @Nullable Terminal terminal) {
        this(colour, terminal, true);
    }

    public TerminalState(boolean colour, @Nullable Terminal terminal, boolean compress) {
        this.colour = colour;
        this.compress = compress;
        if (terminal == null) {
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        } else {
            this.width = terminal.getWidth();
            this.height = terminal.getHeight();
            ByteBuf buf = this.buffer = Unpooled.buffer();
            terminal.write(new PacketBuffer(buf));
        }
    }

    public TerminalState(PacketBuffer buf) {
        this.colour = buf.readBoolean();
        this.compress = buf.readBoolean();
        if (buf.readBoolean()) {
            this.width = buf.func_150792_a();
            this.height = buf.func_150792_a();
            int length = buf.func_150792_a();
            this.buffer = TerminalState.readCompressed((ByteBuf)buf, length, this.compress);
        } else {
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        }
    }

    public void write(PacketBuffer buf) {
        buf.writeBoolean(this.colour);
        buf.writeBoolean(this.compress);
        buf.writeBoolean(this.buffer != null);
        if (this.buffer != null) {
            buf.func_150787_b(this.width);
            buf.func_150787_b(this.height);
            ByteBuf sendBuffer = this.getCompressed();
            buf.func_150787_b(sendBuffer.readableBytes());
            buf.writeBytes(sendBuffer, sendBuffer.readerIndex(), sendBuffer.readableBytes());
        }
    }

    public boolean hasTerminal() {
        return this.buffer != null;
    }

    public int size() {
        return this.buffer == null ? 0 : this.buffer.readableBytes();
    }

    public void apply(Terminal terminal) {
        if (this.buffer == null) {
            throw new NullPointerException("buffer");
        }
        terminal.read(new PacketBuffer(this.buffer));
    }

    private ByteBuf getCompressed() {
        if (this.buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (!this.compress) {
            return this.buffer;
        }
        if (this.compressed != null) {
            return this.compressed;
        }
        ByteBuf compressed = Unpooled.buffer();
        GZIPOutputStream stream = null;
        try {
            stream = new GZIPOutputStream((OutputStream)new ByteBufOutputStream(compressed));
            ((OutputStream)stream).write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.readableBytes());
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(stream);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(stream);
        this.compressed = compressed;
        return this.compressed;
    }

    private static ByteBuf readCompressed(ByteBuf buf, int length, boolean compress) {
        block5: {
            if (!compress) break block5;
            ByteBuf buffer = Unpooled.buffer();
            GZIPInputStream stream = null;
            try {
                int bytes;
                stream = new GZIPInputStream((InputStream)new ByteBufInputStream(buf, length));
                byte[] swap = new byte[8192];
                while ((bytes = ((InputStream)stream).read(swap)) != -1) {
                    buffer.writeBytes(swap, 0, bytes);
                }
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException(e);
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly(stream);
                    throw throwable;
                }
            }
            IoUtil.closeQuietly(stream);
            return buffer;
        }
        ByteBuf buffer = Unpooled.buffer((int)length);
        buf.readBytes(buffer, length);
        return buffer;
    }
}

