/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class BlockTurtle
extends BlockComputerBase<TileTurtle>
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape DEFAULT_SHAPE = VoxelShapes.func_197873_a((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);

    public BlockTurtle(AbstractBlock.Properties settings, ComputerFamily family, RegistryObject<? extends TileEntityType<? extends TileTurtle>> type) {
        super(settings, family, type);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, BlockStateProperties.field_208198_y});
    }

    @Nonnull
    @Deprecated
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(@Nonnull BlockState state, IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        TileEntity tile = world.func_175625_s(pos);
        Vector3d offset = tile instanceof TileTurtle ? ((TileTurtle)tile).getRenderOffset(1.0f) : Vector3d.field_186680_a;
        return offset.equals((Object)Vector3d.field_186680_a) ? DEFAULT_SHAPE : DEFAULT_SHAPE.func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext placement) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placement.func_195992_f())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(WaterloggableHelpers.getWaterloggedStateForPlacement(placement)));
    }

    @Nonnull
    @Deprecated
    public FluidState func_204507_t(@Nonnull BlockState state) {
        return WaterloggableHelpers.getWaterloggedFluidState(state);
    }

    @Nonnull
    @Deprecated
    public BlockState func_196271_a(@Nonnull BlockState state, @Nonnull Direction side, @Nonnull BlockState otherState, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        WaterloggableHelpers.updateWaterloggedPostPlacement(state, world, pos);
        return state;
    }

    @Override
    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile instanceof TileTurtle) {
            TileTurtle turtle = (TileTurtle)tile;
            if (player instanceof PlayerEntity) {
                ((TileTurtle)tile).setOwningPlayer(((PlayerEntity)player).func_146103_bH());
            }
            if (stack.func_77973_b() instanceof ITurtleItem) {
                ResourceLocation overlay;
                ITurtleItem item = (ITurtleItem)stack.func_77973_b();
                for (TurtleSide side : TurtleSide.values()) {
                    turtle.getAccess().setUpgrade(side, item.getUpgrade(stack, side));
                }
                turtle.getAccess().setFuelLevel(item.getFuelLevel(stack));
                int colour = item.getColour(stack);
                if (colour != -1) {
                    turtle.getAccess().setColour(colour);
                }
                if ((overlay = item.getOverlay(stack)) != null) {
                    ((TurtleBrain)turtle.getAccess()).setOverlay(overlay);
                }
            }
        }
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        Entity exploder = explosion.getExploder();
        if (this.getFamily() == ComputerFamily.ADVANCED || exploder instanceof LivingEntity || exploder instanceof DamagingProjectileEntity) {
            return 2000.0f;
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    @Override
    @Nonnull
    protected ItemStack getItem(TileComputerBase tile) {
        return tile instanceof TileTurtle ? TurtleItemFactory.create((TileTurtle)tile) : ItemStack.field_190927_a;
    }
}

