/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.block;

import com.tm.playingcards.block.base.BlockContainerBase;
import com.tm.playingcards.init.InitTileEntityTypes;
import com.tm.playingcards.tileentity.TileEntityPokerTable;
import com.tm.playingcards.util.Location;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockPokerTable
extends BlockContainerBase {
    private static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    private static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    private static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    private static final BooleanProperty NORTHWEST = BooleanProperty.func_177716_a((String)"northwest");
    private static final BooleanProperty NORTHEAST = BooleanProperty.func_177716_a((String)"northeast");
    private static final BooleanProperty SOUTHWEST = BooleanProperty.func_177716_a((String)"southwest");
    private static final BooleanProperty SOUTHEAST = BooleanProperty.func_177716_a((String)"southeast");
    private static final VoxelShape AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public BlockPokerTable() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(1.0f).harvestLevel(0).func_226896_b_().func_208770_d());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTHWEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTHEAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTHWEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTHEAST, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)placer;
            Location location = new Location(world, pos);
            TileEntity tileEntity = location.getTileEntity();
            if (tileEntity instanceof TileEntityPokerTable) {
                TileEntityPokerTable pokerTable = (TileEntityPokerTable)tileEntity;
                pokerTable.setOwner(player);
            }
        }
    }

    private boolean canConnectTo(IBlockReader world, BlockPos pos, int offX, int offZ) {
        BlockPos otherPos = pos.func_177982_a(offX, 0, offZ);
        Block otherBlock = world.func_180495_p(otherPos).func_177230_c();
        return otherBlock instanceof BlockPokerTable;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getState((IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState getState(IWorld world, BlockPos pos) {
        boolean north = this.canConnectTo((IBlockReader)world, pos, 0, -1);
        boolean east = this.canConnectTo((IBlockReader)world, pos, 1, 0);
        boolean south = this.canConnectTo((IBlockReader)world, pos, 0, 1);
        boolean west = this.canConnectTo((IBlockReader)world, pos, -1, 0);
        boolean northwest = this.canConnectTo((IBlockReader)world, pos, -1, -1);
        boolean northeast = this.canConnectTo((IBlockReader)world, pos, 1, -1);
        boolean southwest = this.canConnectTo((IBlockReader)world, pos, -1, 1);
        boolean southeast = this.canConnectTo((IBlockReader)world, pos, 1, 1);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)NORTHWEST, (Comparable)Boolean.valueOf(northwest))).func_206870_a((Property)NORTHEAST, (Comparable)Boolean.valueOf(northeast))).func_206870_a((Property)SOUTHWEST, (Comparable)Boolean.valueOf(southwest))).func_206870_a((Property)SOUTHEAST, (Comparable)Boolean.valueOf(southeast));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.getState(world, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST, NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST});
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return ((TileEntityType)InitTileEntityTypes.POKER_TABLE.get()).func_200968_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }
}

