/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.entity;

import com.tm.playingcards.entity.EntityCardDeck;
import com.tm.playingcards.entity.base.EntityStacked;
import com.tm.playingcards.init.InitEntityTypes;
import com.tm.playingcards.init.InitItems;
import com.tm.playingcards.item.ItemCardCovered;
import com.tm.playingcards.util.ChatHelper;
import com.tm.playingcards.util.ItemHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityCard
extends EntityStacked {
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityCard.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> SKIN_ID = EntityDataManager.func_187226_a(EntityCard.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> DECK_UUID = EntityDataManager.func_187226_a(EntityCard.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> COVERED = EntityDataManager.func_187226_a(EntityCard.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityCard(EntityType<? extends EntityCard> type, World world) {
        super(type, world);
    }

    public EntityCard(World world, Vector3d position, float rotation, byte skinID, UUID deckUUID, boolean covered, byte firstCardID) {
        super((EntityType<? extends EntityStacked>)((EntityType)InitEntityTypes.CARD.get()), world, position);
        this.createStack();
        this.addToTop(firstCardID);
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rotation));
        this.field_70180_af.func_187227_b(SKIN_ID, (Object)skinID);
        this.field_70180_af.func_187227_b(DECK_UUID, Optional.of(deckUUID));
        this.field_70180_af.func_187227_b(COVERED, (Object)covered);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public byte getSkinID() {
        return (Byte)this.field_70180_af.func_187225_a(SKIN_ID);
    }

    public UUID getDeckUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(DECK_UUID)).isPresent() ? (UUID)((Optional)this.field_70180_af.func_187225_a(DECK_UUID)).get() : null;
    }

    public boolean isCover() {
        return (Boolean)this.field_70180_af.func_187225_a(COVERED);
    }

    private void takeCard(PlayerEntity player) {
        ItemStack card = new ItemStack((IItemProvider)InitItems.CARD.get());
        if (((Boolean)this.field_70180_af.func_187225_a(COVERED)).booleanValue()) {
            card = new ItemStack((IItemProvider)InitItems.CARD_COVERED.get());
        }
        card.func_196085_b((int)this.getTopStackID());
        ItemHelper.getNBT(card).func_186854_a("UUID", this.getDeckUUID());
        ItemHelper.getNBT(card).func_74774_a("SkinID", ((Byte)this.field_70180_af.func_187225_a(SKIN_ID)).byteValue());
        if (!this.field_70170_p.field_72995_K) {
            ItemHelper.spawnStackAtEntity(this.field_70170_p, (Entity)player, card);
        }
        this.removeFromTop();
        if (this.getStackAmount() <= 0) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_82737_E() % 20L == 0L) {
            BlockPos pos = this.func_233580_cy_();
            List closeDecks = this.field_70170_p.func_217357_a(EntityCardDeck.class, new AxisAlignedBB((double)(pos.func_177958_n() - 20), (double)(pos.func_177956_o() - 20), (double)(pos.func_177952_p() - 20), (double)(pos.func_177958_n() + 20), (double)(pos.func_177956_o() + 20), (double)(pos.func_177952_p() + 20)));
            boolean foundParentDeck = false;
            for (EntityCardDeck closeDeck : closeDecks) {
                if (!this.getDeckUUID().equals(closeDeck.func_110124_au())) continue;
                foundParentDeck = true;
            }
            if (!foundParentDeck) {
                this.func_70106_y();
            }
            super.onRemovedFromWorld();
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemCardCovered) {
            if (this.getStackAmount() < 52) {
                this.addToTop((byte)stack.func_77952_i());
                stack.func_190918_g(1);
            } else if (this.field_70170_p.field_72995_K) {
                ChatHelper.printModMessage(TextFormatting.RED, "The stack is full!", new Entity[]{player});
            }
        } else {
            this.takeCard(player);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.field_70180_af.func_187227_b(COVERED, (Object)((Boolean)this.field_70180_af.func_187225_a(COVERED) == false ? 1 : 0));
        return true;
    }

    @Override
    public void moreData() {
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SKIN_ID, (Object)0);
        this.field_70180_af.func_187214_a(DECK_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(COVERED, (Object)false);
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(nbt.func_74760_g("Rotation")));
        this.field_70180_af.func_187227_b(SKIN_ID, (Object)nbt.func_74771_c("SkinID"));
        this.field_70180_af.func_187227_b(DECK_UUID, Optional.of(nbt.func_186857_a("DeckID")));
        this.field_70180_af.func_187227_b(COVERED, (Object)nbt.func_74767_n("Covered"));
    }

    @Override
    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74776_a("Rotation", ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue());
        nbt.func_74774_a("SkinID", ((Byte)this.field_70180_af.func_187225_a(SKIN_ID)).byteValue());
        nbt.func_186854_a("DeckID", this.getDeckUUID());
        nbt.func_74757_a("Covered", ((Boolean)this.field_70180_af.func_187225_a(COVERED)).booleanValue());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

