/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.entity;

import com.tm.playingcards.entity.base.EntityStacked;
import com.tm.playingcards.init.InitEntityTypes;
import com.tm.playingcards.init.InitItems;
import com.tm.playingcards.item.ItemPokerChip;
import com.tm.playingcards.util.ChatHelper;
import com.tm.playingcards.util.ItemHelper;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityPokerChip
extends EntityStacked {
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(EntityPokerChip.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(EntityPokerChip.class, (IDataSerializer)DataSerializers.field_187194_d);

    public EntityPokerChip(EntityType<? extends EntityPokerChip> type, World world) {
        super(type, world);
    }

    public EntityPokerChip(World world, Vector3d position, UUID ownerID, String ownerName, byte firstChipID) {
        super((EntityType<? extends EntityStacked>)((EntityType)InitEntityTypes.POKER_CHIP.get()), world, position);
        this.createStack();
        this.addToTop(firstChipID);
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(ownerID));
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)ownerName);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).isPresent() ? (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).get() : null;
    }

    private void takeChip(PlayerEntity player) {
        byte chipID = this.getTopStackID();
        if (!this.field_70170_p.field_72995_K) {
            this.spawnChip(player, ItemPokerChip.getPokerChip(chipID), 1);
        }
        this.removeFromTop();
        if (this.getStackAmount() <= 0) {
            this.func_70106_y();
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemPokerChip) {
            CompoundNBT nbt = ItemHelper.getNBT(stack);
            if (nbt.func_186855_b("OwnerID")) {
                UUID ownerID = nbt.func_186857_a("OwnerID");
                if (ownerID.equals(this.getOwnerUUID())) {
                    if (player.func_213453_ef()) {
                        while (this.getStackAmount() < 52 && stack.func_190916_E() > 0) {
                            ItemPokerChip chip = (ItemPokerChip)stack.func_77973_b();
                            this.addToTop(chip.getChipID());
                            stack.func_190918_g(1);
                        }
                    } else if (this.getStackAmount() < 52) {
                        ItemPokerChip chip = (ItemPokerChip)stack.func_77973_b();
                        this.addToTop(chip.getChipID());
                        stack.func_190918_g(1);
                    } else if (this.field_70170_p.field_72995_K) {
                        ChatHelper.printModMessage(TextFormatting.RED, "The stack is full!", new Entity[]{player});
                    }
                } else if (this.field_70170_p.field_72995_K) {
                    ChatHelper.printModMessage(TextFormatting.RED, "Owner does not match the one of the stack!", new Entity[]{player});
                }
            }
        } else {
            this.takeChip(player);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            int whiteAmount = 0;
            int redAmount = 0;
            int blueAmount = 0;
            int greenAmount = 0;
            int blackAmount = 0;
            for (int i = 0; i < ((Byte[])this.field_70180_af.func_187225_a(STACK)).length; ++i) {
                byte chipID = this.getIDAt(i);
                if (chipID == 0) {
                    ++whiteAmount;
                }
                if (chipID == 1) {
                    ++redAmount;
                }
                if (chipID == 2) {
                    ++blueAmount;
                }
                if (chipID == 3) {
                    ++greenAmount;
                }
                if (chipID != 4) continue;
                ++blackAmount;
            }
            if (whiteAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_WHITE.get(), whiteAmount);
            }
            if (redAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_RED.get(), redAmount);
            }
            if (blueAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_BLUE.get(), blueAmount);
            }
            if (greenAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_GREEN.get(), greenAmount);
            }
            if (blackAmount > 0) {
                this.spawnChip(player, (Item)InitItems.POKER_CHIP_BLACK.get(), blackAmount);
            }
            this.func_70106_y();
            return false;
        }
        return true;
    }

    private void spawnChip(PlayerEntity player, Item item, int amount) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack chip = new ItemStack((IItemProvider)item, amount);
            CompoundNBT nbt = ItemHelper.getNBT(chip);
            nbt.func_186854_a("OwnerID", this.getOwnerUUID());
            nbt.func_74778_a("OwnerName", (String)this.field_70180_af.func_187225_a(OWNER_NAME));
            ItemHelper.spawnStackAtEntity(this.field_70170_p, (Entity)player, chip);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d pos = this.func_213303_ch();
        double size = 0.1;
        double addAmount = 0.01575;
        this.func_174826_a(new AxisAlignedBB(pos.field_72450_a - size, pos.field_72448_b, pos.field_72449_c - size, pos.field_72450_a + size, pos.field_72448_b + 0.02 + addAmount * (double)this.getStackAmount(), pos.field_72449_c + size));
    }

    @Override
    public void moreData() {
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.of(nbt.func_186857_a("OwnerID")));
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)nbt.func_74779_i("OwnerName"));
    }

    @Override
    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_186854_a("OwnerID", this.getOwnerUUID());
        nbt.func_74778_a("OwnerName", (String)this.field_70180_af.func_187225_a(OWNER_NAME));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

