/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.item;

import com.tm.playingcards.entity.EntityPokerChip;
import com.tm.playingcards.init.InitItems;
import com.tm.playingcards.item.base.ItemBase;
import com.tm.playingcards.main.PlayingCards;
import com.tm.playingcards.tileentity.TileEntityPokerTable;
import com.tm.playingcards.util.ItemHelper;
import com.tm.playingcards.util.Location;
import com.tm.playingcards.util.StringHelper;
import com.tm.playingcards.util.UnitChatMessage;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemPokerChip
extends ItemBase {
    private final byte chipID;
    private final int value;

    public ItemPokerChip(byte chipID, int value) {
        super(new Item.Properties().func_200916_a(PlayingCards.TAB));
        this.chipID = chipID;
        this.value = value;
    }

    private UnitChatMessage getUnitMessage(PlayerEntity ... players) {
        return new UnitChatMessage("Poker Chip", (Entity[])players);
    }

    public byte getChipID() {
        return this.chipID;
    }

    public static Item getPokerChip(byte pokerChipID) {
        switch (pokerChipID) {
            case 1: {
                return (Item)InitItems.POKER_CHIP_RED.get();
            }
            case 2: {
                return (Item)InitItems.POKER_CHIP_BLUE.get();
            }
            case 3: {
                return (Item)InitItems.POKER_CHIP_GREEN.get();
            }
            case 4: {
                return (Item)InitItems.POKER_CHIP_BLACK.get();
            }
        }
        return (Item)InitItems.POKER_CHIP_WHITE.get();
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT nbt = ItemHelper.getNBT(stack);
        if (nbt.func_186855_b("OwnerID")) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Owner: " + TextFormatting.GOLD + nbt.func_74779_i("OwnerName")));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Owner: " + TextFormatting.GOLD + "Not set"));
        }
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Value (1): " + TextFormatting.GOLD + this.value));
        if (stack.func_190916_E() > 1) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Value (" + stack.func_190916_E() + "): " + TextFormatting.GOLD + StringHelper.printCommas(this.value * stack.func_190916_E())));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_213453_ef()) {
            UnitChatMessage unitMessage = this.getUnitMessage(player);
            CompoundNBT nbt = ItemHelper.getNBT(heldItem);
            if (!nbt.func_186855_b("OwnerID")) {
                nbt.func_186854_a("OwnerID", player.func_110124_au());
                nbt.func_74778_a("OwnerName", player.func_145748_c_().getString());
                if (world.field_72995_K) {
                    unitMessage.printMessage(TextFormatting.GREEN, "The owner has been set to you!");
                }
            } else if (world.field_72995_K) {
                unitMessage.printMessage(TextFormatting.RED, "An owner already exists!");
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)heldItem);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null && !player.func_213453_ef()) {
            World world = context.func_195991_k();
            Location location = new Location(world, context.func_195995_a());
            UnitChatMessage unitMessage = this.getUnitMessage(player);
            CompoundNBT nbt = ItemHelper.getNBT(context.func_195996_i());
            if (nbt.func_186855_b("OwnerID")) {
                TileEntityPokerTable pokerTable;
                TileEntity tileEntity;
                UUID ownerID = nbt.func_186857_a("OwnerID");
                String ownerName = nbt.func_74779_i("OwnerName");
                if (location.getBlock().hasTileEntity(location.getBlockState()) && (tileEntity = location.getTileEntity()) instanceof TileEntityPokerTable && !ownerID.equals((pokerTable = (TileEntityPokerTable)tileEntity).getOwnerID())) {
                    if (world.field_72995_K) {
                        unitMessage.printMessage(TextFormatting.RED, "The owner of your chip(s) do not match the owner of the table. Cannot place!");
                    }
                    return ActionResultType.PASS;
                }
                EntityPokerChip chip = new EntityPokerChip(world, context.func_221532_j(), ownerID, ownerName, this.chipID);
                world.func_217376_c((Entity)chip);
                context.func_195996_i().func_190918_g(1);
            } else if (world.field_72995_K) {
                unitMessage.printMessage(TextFormatting.RED, "No owner found! Cannot place!");
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

