/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.forge;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.context.IContext;

public class PermissionAPIWrapper
implements IPermissionHandler {
    private final IPermissionHandler original;

    public PermissionAPIWrapper(IPermissionHandler h) {
        this.original = h;
    }

    public void registerNode(String node, DefaultPermissionLevel level, String desc) {
        this.original.registerNode(node, level, desc);
    }

    public Collection<String> getRegisteredNodes() {
        return this.original.getRegisteredNodes();
    }

    public boolean hasPermission(GameProfile profile, String node, @Nullable IContext context) {
        ServerPlayerEntity player;
        if (context != null && context.getPlayer() instanceof ServerPlayerEntity) {
            return FTBRanksAPI.getPermissionValue((ServerPlayerEntity)context.getPlayer(), node).asBoolean().orElseGet(() -> this.original.hasPermission(profile, node, context));
        }
        if (context != null && context.getWorld() != null && !context.getWorld().func_201670_d() && (player = context.getWorld().func_73046_m().func_184103_al().func_177451_a(profile.getId())) != null) {
            return FTBRanksAPI.getPermissionValue(player, node).asBoolean().orElseGet(() -> this.original.hasPermission(profile, node, context));
        }
        return this.original.hasPermission(profile, node, context);
    }

    public String getNodeDescription(String node) {
        return this.original.getNodeDescription(node);
    }
}

