/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankConditionFactory;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.impl.BooleanPermissionValue;
import dev.ftb.mods.ftbranks.impl.FTBRanksCommandManager;
import dev.ftb.mods.ftbranks.impl.NumberPermissionValue;
import dev.ftb.mods.ftbranks.impl.PlayerRankData;
import dev.ftb.mods.ftbranks.impl.RankCommandPredicate;
import dev.ftb.mods.ftbranks.impl.RankImpl;
import dev.ftb.mods.ftbranks.impl.StringPermissionValue;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.OPCondition;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.shedaniel.architectury.hooks.LevelResourceHooks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;

public class RankManagerImpl
implements RankManager {
    public static final FolderName FOLDER_NAME = LevelResourceHooks.create((String)"serverconfig/ftbranks");
    public final MinecraftServer server;
    private Path directory;
    private Path rankFile;
    private Path playerFile;
    boolean shouldSaveRanks;
    boolean shouldSavePlayers;
    private Map<String, RankImpl> ranks;
    private List<RankImpl> sortedRanks;
    private final Map<String, RankConditionFactory> conditions;
    Map<UUID, PlayerRankData> playerData;

    public RankManagerImpl(MinecraftServer s) {
        this.server = s;
        this.conditions = new HashMap<String, RankConditionFactory>();
    }

    void load() throws Exception {
        this.directory = this.server.func_240776_a_(FOLDER_NAME);
        if (Files.notExists(this.directory, new LinkOption[0])) {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        this.rankFile = this.directory.resolve("ranks.snbt");
        this.playerFile = this.directory.resolve("players.snbt");
        Path oldRankFile = this.directory.resolve("ranks.json");
        Path oldPlayerFile = this.directory.resolve("players.json");
        boolean oldRankFileLoaded = false;
        boolean oldPlayerFileLoaded = false;
        if (Files.exists(oldRankFile, new LinkOption[0])) {
            Files.move(oldRankFile, this.rankFile, new CopyOption[0]);
            oldRankFileLoaded = true;
        }
        if (Files.exists(oldPlayerFile, new LinkOption[0])) {
            Files.move(oldPlayerFile, this.playerFile, new CopyOption[0]);
            oldPlayerFileLoaded = true;
        }
        if (oldRankFileLoaded || oldPlayerFileLoaded || Files.notExists(this.directory.resolve("README.txt"), new LinkOption[0])) {
            this.refreshReadme();
        }
        this.reload();
        if (oldRankFileLoaded) {
            this.saveRanks();
            this.saveRanksNow();
        }
        if (oldPlayerFileLoaded) {
            this.savePlayers();
            this.savePlayersNow();
        }
    }

    public void refreshReadme() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("=== FTB Ranks ===");
        lines.add("");
        lines.add("Last README file update: " + new Date());
        lines.add("Wiki: https://www.notion.so/feedthebeast/FTB-Mod-Documentation-da2e359bad2449459d58d787edda3168");
        lines.add("To refresh this file, run /ftbranks refresh_readme");
        lines.add("");
        lines.add("= All available command nodes =");
        lines.add("command");
        HashSet<String> set = new HashSet<String>();
        for (RankCommandPredicate predicate : FTBRanksCommandManager.INSTANCE.commands.values()) {
            set.add(predicate.getNode());
        }
        ArrayList commandList = new ArrayList(set);
        commandList.sort(null);
        lines.addAll(commandList);
        Files.write(this.directory.resolve("README.txt"), lines, new OpenOption[0]);
    }

    @Override
    public void saveRanks() {
        this.shouldSaveRanks = true;
    }

    @Override
    public void savePlayers() {
        this.shouldSavePlayers = true;
    }

    @Override
    public List<Rank> getAllRanks() {
        return this.sortedRanks;
    }

    @Override
    public Optional<Rank> getRank(String id) {
        return Optional.ofNullable((Rank)this.ranks.get(id));
    }

    @Override
    public RankImpl createRank(String id) {
        this.deleteRank(id);
        RankImpl r = new RankImpl(this, id);
        this.ranks.put(id, r);
        this.saveRanks();
        return r;
    }

    public RankImpl createRank(String id, String name) {
        RankImpl rank = this.createRank(id);
        rank.name = name;
        this.saveRanks();
        return rank;
    }

    @Override
    @Nullable
    public RankImpl deleteRank(String id) {
        RankImpl r = this.ranks.get(id);
        if (r != null) {
            for (PlayerRankData rankData : this.playerData.values()) {
                if (rankData.added.remove(r) == null) continue;
                this.savePlayers();
            }
            this.ranks.remove(id);
            this.saveRanks();
        }
        return r;
    }

    public PlayerRankData getPlayerData(GameProfile profile) {
        PlayerRankData data = this.playerData.get(profile.getId());
        if (data == null) {
            data = new PlayerRankData(this, profile.getId());
            data.name = profile.getName();
            this.playerData.put(data.uuid, data);
            this.saveRanks();
        }
        return data;
    }

    @Override
    public Set<Rank> getAddedRanks(GameProfile profile) {
        return this.getPlayerData((GameProfile)profile).added.keySet();
    }

    @Override
    public void registerCondition(String predicate, RankConditionFactory conditionFactory) {
        this.conditions.put(predicate, conditionFactory);
    }

    @Override
    public RankCondition createCondition(Rank rank, @Nullable INBT tag) throws Exception {
        if (tag instanceof StringNBT) {
            SNBTCompoundTag tag1 = new SNBTCompoundTag();
            tag1.func_218657_a("type", tag);
            return this.conditions.get(tag.func_150285_a_()).create(rank, tag1);
        }
        if (tag instanceof SNBTCompoundTag) {
            return this.conditions.get(((SNBTCompoundTag)tag).func_74779_i("type")).create(rank, (SNBTCompoundTag)tag);
        }
        throw new IllegalArgumentException("Can't create condition from tag " + tag);
    }

    @Override
    public PermissionValue getPermissionValue(ServerPlayerEntity player, String node) {
        if (node.isEmpty() || this.sortedRanks == null || this.sortedRanks.isEmpty()) {
            return PermissionValue.DEFAULT;
        }
        try {
            ArrayList<RankImpl> list = new ArrayList<RankImpl>();
            for (RankImpl rank : this.sortedRanks) {
                if (!rank.isActive(player)) continue;
                list.add(rank);
            }
            return this.getPermissionValue(this.getPlayerData(player.func_146103_bH()), list, node);
        }
        catch (Exception ex) {
            FTBRanks.LOGGER.error("Error getting permission value for node " + node + "!");
            ex.printStackTrace();
            return PermissionValue.DEFAULT;
        }
    }

    private PermissionValue getPermissionValue(PlayerRankData data, List<RankImpl> ranks, String node) {
        if (node.isEmpty()) {
            return PermissionValue.DEFAULT;
        }
        PermissionValue pvalue = data.permissions.get(node);
        if (pvalue != null) {
            return pvalue;
        }
        for (RankImpl rank : ranks) {
            PermissionValue value = rank.permissions.get(node);
            if (value == null) continue;
            return value;
        }
        int i = node.lastIndexOf(46);
        return i == -1 ? PermissionValue.DEFAULT : this.getPermissionValue(data, ranks, node.substring(0, i));
    }

    public void reload() throws Exception {
        SNBTCompoundTag playerFileTag;
        SNBTCompoundTag o;
        this.shouldSaveRanks = false;
        if (Files.notExists(this.rankFile, new LinkOption[0])) {
            this.ranks = new LinkedHashMap<String, RankImpl>();
            RankImpl memberRank = new RankImpl(this, "member");
            memberRank.setPermission("name", StringPermissionValue.of("Member"));
            memberRank.setPermission("power", NumberPermissionValue.of(1));
            memberRank.setPermission("ftbranks.name_format", StringPermissionValue.of("<{name}>"));
            memberRank.condition = AlwaysActiveCondition.INSTANCE;
            this.ranks.put("member", memberRank);
            RankImpl vipRank = new RankImpl(this, "vip");
            vipRank.setPermission("name", StringPermissionValue.of("VIP"));
            vipRank.setPermission("power", NumberPermissionValue.of(50));
            vipRank.setPermission("ftbranks.name_format", StringPermissionValue.of("<&bVIP {name}&r>"));
            this.ranks.put("vip", vipRank);
            RankImpl adminRank = new RankImpl(this, "admin");
            adminRank.setPermission("name", StringPermissionValue.of("Admin"));
            adminRank.setPermission("power", NumberPermissionValue.of(1000));
            adminRank.setPermission("ftbranks.name_format", StringPermissionValue.of("<&2{name}&r>"));
            adminRank.condition = new OPCondition();
            this.ranks.put("admin", adminRank);
            this.saveRanks();
            this.saveRanksNow();
        }
        if (Files.notExists(this.playerFile, new LinkOption[0])) {
            this.playerData = new HashMap<UUID, PlayerRankData>();
            this.savePlayers();
            this.savePlayersNow();
        }
        LinkedHashMap<String, RankImpl> tempRanks = new LinkedHashMap<String, RankImpl>();
        LinkedHashMap<UUID, PlayerRankData> tempPlayerData = new LinkedHashMap<UUID, PlayerRankData>();
        SNBTCompoundTag rankFileTag = SNBT.read((Path)this.rankFile);
        if (rankFileTag != null) {
            for (String key : rankFileTag.func_150296_c()) {
                RankImpl rank = new RankImpl(this, key);
                o = rankFileTag.getCompound(key);
                rank.name = o.func_74779_i("name");
                rank.power = o.func_74762_e("power");
                if (o.func_74764_b("condition")) {
                    try {
                        rank.condition = this.createCondition(rank, o.func_74781_a("condition"));
                    }
                    catch (Exception ex) {
                        FTBRanks.LOGGER.error("Failed to parse condition for " + rank.id + ": " + ex);
                    }
                }
                o.func_82580_o("name");
                o.func_82580_o("power");
                o.func_82580_o("condition");
                for (String pkey : o.func_150296_c()) {
                    while (pkey.endsWith(".*")) {
                        pkey = pkey.substring(0, pkey.length() - 2);
                        this.saveRanks();
                    }
                    if (pkey.isEmpty()) continue;
                    rank.permissions.put(pkey, RankManagerImpl.ofTag(o, pkey));
                }
                if (rank.name.isEmpty()) {
                    rank.name = rank.id;
                    this.saveRanks();
                }
                tempRanks.put(rank.id, rank);
            }
            if (tempRanks.isEmpty()) {
                FTBRanks.LOGGER.warn("No ranks found!");
            }
        }
        if ((playerFileTag = SNBT.read((Path)this.playerFile)) != null) {
            for (String key : playerFileTag.func_150296_c()) {
                o = playerFileTag.getCompound(key);
                PlayerRankData data = new PlayerRankData(this, UUID.fromString(key));
                data.name = o.func_74779_i("name");
                SNBTCompoundTag ranksTag = o.getCompound("ranks");
                for (String rkey : ranksTag.func_150296_c()) {
                    RankImpl rank = (RankImpl)tempRanks.get(rkey);
                    if (rank == null) continue;
                    data.added.put(rank, Instant.parse(ranksTag.func_74779_i(rkey)));
                }
                if (o.func_74764_b("permissions")) {
                    SNBTCompoundTag ptag = o.getCompound("permissions");
                    for (String pkey : ptag.func_150296_c()) {
                        while (pkey.endsWith(".*")) {
                            pkey = pkey.substring(0, pkey.length() - 2);
                            this.savePlayers();
                        }
                        if (pkey.isEmpty()) continue;
                        data.permissions.put(key, RankManagerImpl.ofTag(ptag, pkey));
                    }
                }
                tempPlayerData.put(data.uuid, data);
            }
        }
        this.ranks = new LinkedHashMap<String, RankImpl>(tempRanks);
        this.playerData = new LinkedHashMap<UUID, PlayerRankData>(tempPlayerData);
        this.sortedRanks = new ArrayList<RankImpl>(this.ranks.values());
        this.sortedRanks.sort(null);
        FTBRanks.LOGGER.info("Loaded " + this.ranks.size() + " ranks");
    }

    public void saveRanksNow() {
        if (!this.shouldSaveRanks) {
            return;
        }
        this.shouldSaveRanks = false;
        SNBTCompoundTag tag = new SNBTCompoundTag();
        for (RankImpl rank : this.ranks.values()) {
            SNBTCompoundTag o = new SNBTCompoundTag();
            o.func_74778_a("name", rank.getName());
            o.func_74768_a("power", rank.getPower());
            if (!rank.condition.isDefaultCondition()) {
                if (rank.condition.isSimple()) {
                    o.func_74778_a("condition", rank.condition.getType());
                } else {
                    SNBTCompoundTag c = new SNBTCompoundTag();
                    c.func_74778_a("type", rank.condition.getType());
                    rank.condition.save(c);
                    o.func_218657_a("condition", (INBT)c);
                }
            }
            for (Map.Entry<String, PermissionValue> entry : rank.permissions.entrySet()) {
                PermissionValue v = entry.getValue();
                if (v.isDefaultValue()) {
                    o.putNull(entry.getKey());
                    continue;
                }
                if (v instanceof BooleanPermissionValue) {
                    o.func_74757_a(entry.getKey(), ((BooleanPermissionValue)entry.getValue()).value);
                    continue;
                }
                if (v instanceof StringPermissionValue) {
                    o.func_74778_a(entry.getKey(), ((StringPermissionValue)entry.getValue()).value);
                    continue;
                }
                if (v instanceof NumberPermissionValue) {
                    o.putNumber(entry.getKey(), ((NumberPermissionValue)entry.getValue()).value);
                    continue;
                }
                o.func_74778_a(entry.getKey(), entry.getValue().asString().orElse(""));
            }
            tag.func_218657_a(rank.id, (INBT)o);
        }
        if (!SNBT.write((Path)this.rankFile, (CompoundNBT)tag)) {
            FTBRanks.LOGGER.warn("Failed to save ranks.snbt!");
        }
    }

    public void savePlayersNow() {
        if (!this.shouldSavePlayers) {
            return;
        }
        this.shouldSavePlayers = false;
        SNBTCompoundTag playerJson = new SNBTCompoundTag();
        for (PlayerRankData data : this.playerData.values()) {
            SNBTCompoundTag o = new SNBTCompoundTag();
            o.func_74778_a("name", data.name);
            SNBTCompoundTag r = new SNBTCompoundTag();
            for (Map.Entry<Rank, Instant> entry : data.added.entrySet()) {
                if (!entry.getKey().getCondition().isDefaultCondition()) continue;
                r.func_74778_a(entry.getKey().getId(), entry.getValue().toString());
            }
            o.func_218657_a("ranks", (INBT)r);
            if (!data.permissions.isEmpty()) {
                SNBTCompoundTag p = new SNBTCompoundTag();
                for (Map.Entry<String, PermissionValue> entry : data.permissions.entrySet()) {
                    PermissionValue v = entry.getValue();
                    if (v.isDefaultValue()) {
                        p.putNull(entry.getKey());
                        continue;
                    }
                    if (v instanceof BooleanPermissionValue) {
                        p.func_74757_a(entry.getKey(), ((BooleanPermissionValue)entry.getValue()).value);
                        continue;
                    }
                    if (v instanceof StringPermissionValue) {
                        p.func_74778_a(entry.getKey(), ((StringPermissionValue)entry.getValue()).value);
                        continue;
                    }
                    if (v instanceof NumberPermissionValue) {
                        p.putNumber(entry.getKey(), ((NumberPermissionValue)entry.getValue()).value);
                        continue;
                    }
                    p.func_74778_a(entry.getKey(), entry.getValue().asString().orElse(""));
                }
                o.func_218657_a("permissions", (INBT)p);
            }
            playerJson.func_218657_a(data.uuid.toString(), (INBT)o);
        }
        if (!SNBT.write((Path)this.playerFile, (CompoundNBT)playerJson)) {
            FTBRanks.LOGGER.warn("Failed to save players.snbt!");
        }
    }

    private static PermissionValue ofTag(SNBTCompoundTag tag, String key) {
        if (tag.isBoolean(key)) {
            return BooleanPermissionValue.of(tag.func_74767_n(key));
        }
        INBT v = tag.func_74781_a(key);
        if (v == null || v instanceof EndNBT) {
            return PermissionValue.DEFAULT;
        }
        if (v instanceof NumberNBT) {
            return NumberPermissionValue.of(((NumberNBT)v).func_209908_j());
        }
        if (v instanceof StringNBT) {
            return StringPermissionValue.of(v.func_150285_a_());
        }
        return StringPermissionValue.of(v.toString());
    }
}

