/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.EventBlockBitModification;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IVoxelBlobItem;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.packets.PacketAccurateSneakPlace;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class ItemBlockChiseled
extends BlockItem
implements IVoxelBlobItem,
IItemScrollWheel,
PacketAccurateSneakPlace.IItemBlockAccurate {
    SimpleInstanceCache<ItemStack, List<ITextComponent>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public ItemBlockChiseled(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpChiseledBlock, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(ClientSide.getOffGridPlacementKey()));
        if (stack.func_77942_o()) {
            if (ClientSide.instance.holdingShift()) {
                if (this.tooltipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.tooltipCache.updateCachedValue(blob.listContents(new ArrayList<ITextComponent>()));
                }
                tooltip.addAll((Collection<ITextComponent>)this.tooltipCache.getCached());
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(LocalStrings.ShiftDetails.getLocal()));
            }
        }
    }

    protected boolean func_195944_a(BlockItemUseContext p_195944_1_, BlockState p_195944_2_) {
        return this.canPlaceBlockHere(p_195944_1_.func_195991_k(), p_195944_1_.func_195995_a(), p_195944_1_.func_196000_l(), p_195944_1_.func_195999_j(), p_195944_1_.func_221531_n(), p_195944_1_.func_195996_i(), p_195944_1_.func_221532_j().field_72450_a, p_195944_1_.func_221532_j().field_72448_b, p_195944_1_.func_221532_j().field_72449_c, false);
    }

    public boolean vanillaStylePlacementTest(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Direction side, PlayerEntity player, Hand hand, ItemStack stack) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150433_aE) {
            side = Direction.UP;
        } else if (!block.func_196253_a(worldIn.func_180495_p(pos), new BlockItemUseContext(player, hand, stack, new BlockRayTraceResult(new Vector3d(0.5, 0.5, 0.5), side, pos, false)))) {
            pos = pos.func_177972_a(side);
        }
        return true;
    }

    public boolean canPlaceBlockHere(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Direction side, PlayerEntity player, Hand hand, ItemStack stack, double hitX, double hitY, double hitZ, boolean offgrid) {
        if (this.vanillaStylePlacementTest(worldIn, pos, side, player, hand, stack)) {
            return true;
        }
        if (offgrid) {
            return true;
        }
        if (ItemBlockChiseled.tryPlaceBlockAt(this.func_179223_d(), stack, player, worldIn, pos, side, Hand.MAIN_HAND, hitX, hitY, hitZ, null, false)) {
            return true;
        }
        return ItemBlockChiseled.tryPlaceBlockAt(this.func_179223_d(), stack, player, worldIn, pos.func_177972_a(side), side, Hand.MAIN_HAND, hitX, hitY, hitZ, null, false);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (!context.func_195991_k().field_72995_K && !(context.func_195999_j() instanceof FakePlayer)) {
            return ActionResultType.SUCCESS;
        }
        PacketAccurateSneakPlace pasp = new PacketAccurateSneakPlace(context.func_195996_i(), context.func_195995_a(), context.func_221531_n(), context.func_196000_l(), context.func_221532_j().field_72450_a, context.func_221532_j().field_72448_b, context.func_221532_j().field_72449_c, ClientSide.offGridPlacement(context.func_195999_j()));
        ChiselsAndBits.getNetworkChannel().sendToServer(pasp);
        return this.tryPlace((ItemUseContext)new BlockItemUseContext(context), ClientSide.offGridPlacement(context.func_195999_j()));
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        return this.tryPlace((ItemUseContext)context, false);
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        return this.placeBitBlock(context.func_195996_i(), context.func_195999_j(), context.func_195991_k(), context.func_195995_a(), context.func_196000_l(), context.func_221532_j().field_72450_a, context.func_221532_j().field_72448_b, context.func_221532_j().field_72449_c, state, false);
    }

    public boolean placeBitBlock(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction side, double hitX, double hitY, double hitZ, BlockState newState, boolean offgrid) {
        if (offgrid) {
            BitLocation bl = new BitLocation(new BlockRayTraceResult(new Vector3d(hitX, hitY, hitZ), side, pos, false), BitOperation.PLACE);
            return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, player, world, bl.blockPos, side, Hand.MAIN_HAND, hitX, hitY, hitZ, new BlockPos(bl.bitX, bl.bitY, bl.bitZ), true);
        }
        return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, player, world, pos, side, Hand.MAIN_HAND, hitX, hitY, hitZ, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryPlaceBlockAt(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull PlayerEntity player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side, @Nonnull Hand hand, double hitX, double hitY, double hitZ, BlockPos partial, boolean modulateWorld) {
        int z;
        int y;
        int x;
        BlockPos offset;
        VoxelBlob[][][] blobs = new VoxelBlob[2][2][2];
        if (!stack.func_77942_o()) {
            return false;
        }
        VoxelBlob source = ModUtil.getBlobFromStack(stack, (LivingEntity)player);
        IntegerBox modelBounds = source.getBounds();
        BlockPos blockPos = offset = partial == null || modelBounds == null ? new BlockPos(0, 0, 0) : ModUtil.getPartialOffset(side, partial, modelBounds);
        if (offset.func_177958_n() < 0) {
            pos = pos.func_177982_a(-1, 0, 0);
            offset = offset.func_177982_a(16, 0, 0);
        }
        if (offset.func_177956_o() < 0) {
            pos = pos.func_177982_a(0, -1, 0);
            offset = offset.func_177982_a(0, 16, 0);
        }
        if (offset.func_177952_p() < 0) {
            pos = pos.func_177982_a(0, 0, -1);
            offset = offset.func_177982_a(0, 0, 16);
        }
        for (x = 0; x < 2; ++x) {
            for (y = 0; y < 2; ++y) {
                for (z = 0; z < 2; ++z) {
                    blobs[x][y][z] = source.offset(offset.func_177958_n() - source.detail * x, offset.func_177956_o() - source.detail * y, offset.func_177952_p() - source.detail * z);
                    int solids = blobs[x][y][z].filled();
                    if (solids <= 0) continue;
                    BlockPos bp = pos.func_177982_a(x, y, z);
                    EventBlockBitModification bmm = new EventBlockBitModification(world, bp, player, hand, stack, true);
                    MinecraftForge.EVENT_BUS.post((Event)bmm);
                    if (!world.func_175660_a(player, bp) || bmm.isCanceled()) {
                        return false;
                    }
                    if (world.func_175623_d(bp) || world.func_180495_p(bp).func_196953_a(new BlockItemUseContext(player, hand, stack, new BlockRayTraceResult(new Vector3d(hitX, hitY, hitZ), side, pos, false)))) continue;
                    TileEntityBlockChiseled target = ModUtil.getChiseledTileEntity(world, bp, true);
                    if (target != null) {
                        if (!target.canMerge(blobs[x][y][z])) {
                            return false;
                        }
                        blobs[x][y][z] = blobs[x][y][z].merge(target.getBlob());
                        continue;
                    }
                    return false;
                }
            }
        }
        if (modulateWorld) {
            UndoTracker.getInstance().beginGroup(player);
            try {
                for (x = 0; x < 2; ++x) {
                    for (y = 0; y < 2; ++y) {
                        for (z = 0; z < 2; ++z) {
                            if (blobs[x][y][z].filled() <= 0) continue;
                            BlockPos bp = pos.func_177982_a(x, y, z);
                            BlockState state = world.func_180495_p(bp);
                            if (world.func_180495_p(bp).func_196953_a(new BlockItemUseContext(player, hand, stack, new BlockRayTraceResult(new Vector3d(hitX, hitY, hitZ), side, bp, false)))) {
                                world.func_175656_a(bp, Blocks.field_150350_a.func_176223_P());
                            }
                            if (world.func_175623_d(bp)) {
                                int commonBlock = blobs[x][y][z].getVoxelStats().mostCommonState;
                                BlockChiseled.ReplaceWithChiseledValue rv = BlockChiseled.replaceWithChiseled(world, bp, state, commonBlock, true);
                                if (!rv.success || rv.te == null) continue;
                                rv.te.completeEditOperation(blobs[x][y][z]);
                                continue;
                            }
                            TileEntityBlockChiseled target = ModUtil.getChiseledTileEntity(world, bp, true);
                            if (target != null) {
                                target.completeEditOperation(blobs[x][y][z]);
                                continue;
                            }
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            finally {
                UndoTracker.getInstance().endGroup(player);
            }
        }
        return true;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT BlockEntityTag;
        CompoundNBT comp = stack.func_77978_p();
        if (comp != null && (BlockEntityTag = comp.func_74775_l("BlockEntityTag")) != null) {
            NBTBlobConverter c = new NBTBlobConverter();
            c.readChisleData(BlockEntityTag, -1);
            BlockState state = c.getPrimaryBlockState();
            ITextComponent name = ItemChiseledBit.getBitStateName(state);
            if (name != null) {
                ITextComponent parent = super.func_200295_i(stack);
                if (!(parent instanceof IFormattableTextComponent)) {
                    return parent;
                }
                IFormattableTextComponent formattedParent = (IFormattableTextComponent)parent;
                return formattedParent.func_240702_b_(" - ").func_230529_a_(name);
            }
        }
        return super.func_200295_i(stack);
    }

    @Override
    public void scroll(PlayerEntity player, ItemStack stack, int dwheel) {
        PacketRotateVoxelBlob p = new PacketRotateVoxelBlob(Direction.Axis.Y, dwheel > 0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        ChiselsAndBits.getNetworkChannel().sendToServer(p);
    }

    @Override
    public void rotate(ItemStack stack, Direction.Axis axis, Rotation rotation) {
        Direction side = ModUtil.getSide(stack);
        if (axis == Direction.Axis.Y) {
            switch (rotation) {
                case CLOCKWISE_180: {
                    side = side.func_176746_e();
                }
                case CLOCKWISE_90: {
                    side = side.func_176746_e();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    side = side.func_176735_f();
                    break;
                }
            }
        } else {
            IBitAccess ba = ChiselsAndBits.getApi().createBitItem(stack);
            ba.rotate(axis, rotation);
            stack.func_77982_d(ba.getBitsAsItem(side, ChiselsAndBits.getApi().getItemType(stack), false).func_77978_p());
        }
        ModUtil.setSide(stack, side);
    }

    @Override
    public ActionResultType tryPlace(ItemUseContext context, boolean offgrid) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        Block block = state.func_177230_c();
        Direction side = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        if (block == Blocks.field_150433_aE && (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) < 1) {
            side = Direction.UP;
        } else {
            BlockItemUseContext replacementCheckContext;
            TileEntityBlockChiseled tebc;
            boolean canMerge = false;
            if (context.func_195996_i().func_77942_o() && (tebc = ModUtil.getChiseledTileEntity(context.func_195991_k(), context.func_195995_a(), true)) != null) {
                VoxelBlob blob = ModUtil.getBlobFromStack(context.func_195996_i(), (LivingEntity)context.func_195999_j());
                canMerge = tebc.canMerge(blob);
            }
            BlockItemUseContext blockItemUseContext = replacementCheckContext = context instanceof BlockItemUseContext ? (BlockItemUseContext)context : new BlockItemUseContext(context);
            if (context.func_195999_j().func_130014_f_().func_180495_p(context.func_195995_a()).func_177230_c() instanceof BlockChiseled) {
                replacementCheckContext = new DirectionalPlaceContext(context.func_195991_k(), pos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP);
            }
            if (!(canMerge || offgrid || state.func_196953_a(replacementCheckContext))) {
                pos = pos.func_177972_a(side);
            }
        }
        if (ModUtil.isEmpty(context.func_195996_i())) {
            return ActionResultType.FAIL;
        }
        if (!context.func_195999_j().func_175151_a(pos, side, context.func_195996_i())) {
            return ActionResultType.FAIL;
        }
        if (pos.func_177956_o() == 255 && DeprecationHelper.getStateFromItem(context.func_195996_i()).func_185904_a().func_76220_a()) {
            return ActionResultType.FAIL;
        }
        if (context instanceof BlockItemUseContext && this.canPlaceBlockHere(context.func_195991_k(), pos, side, context.func_195999_j(), context.func_221531_n(), context.func_195996_i(), context.func_221532_j().field_72450_a, context.func_221532_j().field_72448_b, context.func_221532_j().field_72449_c, offgrid)) {
            int i = context.func_195996_i().func_77952_i();
            BlockState BlockState1 = this.func_195945_b((BlockItemUseContext)context);
            if (this.placeBitBlock(context.func_195996_i(), context.func_195999_j(), context.func_195991_k(), pos, side, context.func_221532_j().field_72450_a, context.func_221532_j().field_72448_b, context.func_221532_j().field_72449_c, BlockState1, offgrid)) {
                context.func_195991_k().func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, DeprecationHelper.getSoundType(this.func_179223_d()).func_185841_e(), SoundCategory.BLOCKS, (DeprecationHelper.getSoundType(this.field_150939_a).func_185843_a() + 1.0f) / 2.0f, DeprecationHelper.getSoundType(this.field_150939_a).func_185847_b() * 0.8f, false);
                if (!context.func_195999_j().func_184812_l_() && context.func_195996_i().func_77973_b() instanceof ItemBlockChiseled) {
                    ModUtil.adjustStackSize(context.func_195996_i(), -1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.FAIL;
    }
}

