/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.modes.PositivePatternMode;
import mod.chiselsandbits.network.packets.PacketSetChiselMode;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ChiselModeManager {
    private static ChiselMode clientChiselMode = ChiselMode.SINGLE;
    private static ChiselMode clientBitMode = ChiselMode.SINGLE;

    public static void changeChiselMode(ChiselToolType tool, IToolMode originalMode, IToolMode newClientChiselMode) {
        boolean chatNotification = (Boolean)ChiselsAndBits.getConfig().getClient().chatModeNotification.get();
        boolean itemNameModeDisplay = (Boolean)ChiselsAndBits.getConfig().getClient().itemNameModeDisplay.get();
        if (((Boolean)ChiselsAndBits.getConfig().getClient().perChiselMode.get()).booleanValue() && tool.hasPerToolSettings() || tool.requiresPerToolSettings()) {
            PacketSetChiselMode packet = new PacketSetChiselMode(newClientChiselMode, tool, chatNotification);
            if (!itemNameModeDisplay) {
                newClientChiselMode.setMode(Minecraft.func_71410_x().field_71439_g.func_184614_ca());
            }
            ChiselsAndBits.getNetworkChannel().sendToServer(packet);
        } else {
            if (tool == ChiselToolType.CHISEL) {
                clientChiselMode = (ChiselMode)newClientChiselMode;
            } else {
                clientBitMode = (ChiselMode)newClientChiselMode;
            }
            if (originalMode != newClientChiselMode && chatNotification) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent(newClientChiselMode.getName().toString()), Util.field_240973_b_);
            }
            ReflectionWrapper.instance.clearHighlightedStack();
        }
        if (!itemNameModeDisplay) {
            ReflectionWrapper.instance.endHighlightedStack();
        }
    }

    public static void scrollOption(ChiselToolType tool, IToolMode originalMode, IToolMode currentMode, int dwheel) {
        int offset = currentMode.ordinal() + (dwheel < 0 ? -1 : 1);
        if (offset >= ChiselMode.values().length) {
            offset = 0;
        }
        if (offset < 0) {
            offset = ChiselMode.values().length - 1;
        }
        if ((currentMode = ChiselMode.values()[offset]).isDisabled()) {
            ChiselModeManager.scrollOption(tool, originalMode, currentMode, dwheel);
        } else {
            ChiselModeManager.changeChiselMode(tool, originalMode, currentMode);
        }
    }

    public static IToolMode getChiselMode(PlayerEntity player, ChiselToolType setting, Hand hand) {
        if (setting == ChiselToolType.TAPEMEASURE || setting == ChiselToolType.POSITIVEPATTERN) {
            ItemStack ei = player.func_184586_b(hand);
            if (ei != null && ei.func_77973_b() instanceof IChiselModeItem) {
                return setting.getMode(ei);
            }
            return PositivePatternMode.REPLACE;
        }
        if (setting == ChiselToolType.CHISEL) {
            ItemStack ei;
            if (((Boolean)ChiselsAndBits.getConfig().getClient().perChiselMode.get()).booleanValue() && (ei = player.func_184614_ca()) != null && ei.func_77973_b() instanceof IChiselModeItem) {
                return setting.getMode(ei);
            }
            return clientChiselMode;
        }
        if (setting == ChiselToolType.BIT) {
            return clientBitMode;
        }
        return ChiselMode.SINGLE;
    }
}

