/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.bitbag.BagCapabilityProvider;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.bitbag.BagStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.packets.PacketOpenBagGui;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemBitBag
extends Item {
    public static final int INTS_PER_BIT_TYPE = 2;
    public static final int OFFSET_STATE_ID = 0;
    public static final int OFFSET_QUANTITY = 1;
    SimpleInstanceCache<ItemStack, List<ITextComponent>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public ItemBitBag(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new BagCapabilityProvider(stack, nbt);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        DyeColor color = ItemBitBag.getDyedColor(stack);
        ITextComponent parent = super.func_200295_i(stack);
        if (parent instanceof IFormattableTextComponent && color != null) {
            return ((IFormattableTextComponent)parent).func_240702_b_(" - ").func_230529_a_((ITextComponent)new TranslationTextComponent("chiselsandbits.color." + color.func_176762_d()));
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        List<ITextComponent> details;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpBitBag, tooltip, new String[0]);
        if (this.tooltipCache.needsUpdate(stack)) {
            BagInventory bi = new BagInventory(stack);
            this.tooltipCache.updateCachedValue(bi.listContents(new ArrayList<ITextComponent>()));
        }
        if ((details = this.tooltipCache.getCached()).size() <= 2 || ClientSide.instance.holdingShift()) {
            tooltip.addAll(details);
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(LocalStrings.ShiftDetails.getLocal()));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            ChiselsAndBits.getNetworkChannel().sendToServer(new PacketOpenBagGui());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
    }

    public static void cleanupInventory(PlayerEntity player, ItemStack is) {
        if (is != null && is.func_77973_b() instanceof ItemChiseledBit) {
            PlayerInventory inv = player.field_71071_by;
            List<BagPos> bags = ItemBitBag.getBags((IInventory)inv);
            int firstSeen = -1;
            block0: for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                int actingSlot = slot;
                ItemStack which = ModUtil.nonNull(inv.func_70301_a(actingSlot));
                if (which == null || which.func_77973_b() != is.func_77973_b() || !ItemChiseledBit.sameBit(which, ItemChiseledBit.getStackState(is))) continue;
                if (actingSlot == player.field_71071_by.field_70461_c) {
                    if (firstSeen == -1) continue;
                    actingSlot = firstSeen;
                }
                which = ModUtil.nonNull(inv.func_70301_a(actingSlot));
                if (firstSeen == -1) {
                    firstSeen = actingSlot;
                    continue;
                }
                for (BagPos i : bags) {
                    if (!ModUtil.isEmpty(which = i.inv.insertItem(which))) continue;
                    inv.func_70299_a(actingSlot, which);
                    continue block0;
                }
            }
        }
    }

    public static List<BagPos> getBags(IInventory inv) {
        ArrayList<BagPos> bags = new ArrayList<BagPos>();
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack which = inv.func_70301_a(x);
            if (which == null || !(which.func_77973_b() instanceof ItemBitBag)) continue;
            bags.add(new BagPos(new BagInventory(which)));
        }
        return bags;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        LazyOptional o = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (o instanceof BagStorage) {
            int qty = ((BagStorage)o).getSlotsUsed();
            return qty != 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        LazyOptional o = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (o instanceof BagStorage) {
            int qty = ((BagStorage)o).getSlotsUsed();
            double value = (float)qty / 63.0f;
            return Math.min(1.0, Math.max(0.0, (Boolean)ChiselsAndBits.getConfig().getClient().invertBitBagFullness.get() != false ? value : 1.0 - value));
        }
        return 0.0;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            if (this == ModItems.ITEM_BIT_BAG_DEFAULT.get()) {
                items.add((Object)new ItemStack((IItemProvider)this));
            } else {
                for (DyeColor color : DyeColor.values()) {
                    items.add((Object)ItemBitBag.dyeBag(new ItemStack((IItemProvider)this), color));
                }
            }
        }
    }

    public static ItemStack dyeBag(ItemStack bag, DyeColor color) {
        ItemStack copy = bag.func_77946_l();
        if (!copy.func_77942_o()) {
            copy.func_77982_d(new CompoundNBT());
        }
        if (color == null && bag.func_77973_b() == ModItems.ITEM_BIT_BAG_DYED.get()) {
            ItemStack unColoredStack = new ItemStack((IItemProvider)ModItems.ITEM_BIT_BAG_DEFAULT.get());
            unColoredStack.func_77982_d(copy.func_77978_p());
            unColoredStack.func_77978_p().func_82580_o("color");
            return unColoredStack;
        }
        if (color != null) {
            ItemStack coloredStack = copy;
            if (coloredStack.func_77973_b() == ModItems.ITEM_BIT_BAG_DEFAULT.get()) {
                coloredStack = new ItemStack((IItemProvider)ModItems.ITEM_BIT_BAG_DYED.get());
                coloredStack.func_77982_d(copy.func_77978_p());
            }
            coloredStack.func_77978_p().func_74778_a("color", color.func_176762_d());
            return coloredStack;
        }
        return copy;
    }

    public static DyeColor getDyedColor(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.ITEM_BIT_BAG_DYED.get()) {
            return null;
        }
        if (stack.func_196082_o().func_74764_b("color")) {
            String name = stack.func_77978_p().func_74779_i("color");
            for (DyeColor color : DyeColor.values()) {
                if (!name.equals(color.func_176610_l())) continue;
                return color;
            }
        }
        return null;
    }

    public static class BagPos {
        public final BagInventory inv;

        public BagPos(BagInventory bagInventory) {
            this.inv = bagInventory;
        }
    }
}

