/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import its_meow.betteranimalsplus.common.entity.util.EntityUtil;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithSelectiveTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class EntitySquirrel
extends EntityAnimalWithSelectiveTypes {
    protected static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntitySquirrel.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int climbTimeWithoutLog = 0;

    public EntitySquirrel(EntityType<? extends EntitySquirrel> entityType, World worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)entityType, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 0.72));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 0.5, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 10.0f, 0.5, 0.7));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            boolean nearLog = false;
            for (Direction facing : Direction.values()) {
                BlockPos pos = this.func_233580_cy_().func_177972_a(facing);
                Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                if (block != Blocks.field_196621_O && block != Blocks.field_196619_M && block != Blocks.field_196623_P && block != Blocks.field_196620_N && block != Blocks.field_196617_K && block != Blocks.field_196618_L) continue;
                nearLog = true;
            }
            this.setBesideClimbableBlock(this.field_70123_F && nearLog || this.field_70123_F && this.climbTimeWithoutLog < 15);
            if (this.field_70123_F && !nearLog) {
                ++this.climbTimeWithoutLog;
            } else if (this.climbTimeWithoutLog > 0 || this.field_70123_F) {
                this.climbTimeWithoutLog = 0;
            }
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        EntitySquirrel squirrel = (EntitySquirrel)this.getContainer().getEntityType().func_200721_a((World)world);
        if (ageable instanceof EntitySquirrel) {
            EntitySquirrel other = (EntitySquirrel)ageable;
            if ((this.isAlbino() || other.isAlbino()) && !this.getVariantNameOrEmpty().equals(other.getVariantNameOrEmpty())) {
                squirrel.setType(this.isAlbino() ? (IVariant)other.getVariant().get() : (IVariant)this.getVariant().get());
            } else {
                squirrel.setType(this.field_70146_Z.nextBoolean() ? (IVariant)this.getVariant().get() : (IVariant)other.getVariant().get());
            }
        }
        return squirrel;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151014_N || stack.func_77973_b() == Items.field_185163_cU || stack.func_77973_b() == Items.field_151081_bc || stack.func_77973_b() == Items.field_151080_bb;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    protected EntitySquirrel getBaseChild() {
        return null;
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingdata, CompoundNBT compound) {
        return EntityUtil.childChance((AgeableEntity)this, reason, super.func_213386_a(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    @Override
    public String[] getTypesFor(RegistryKey<Biome> biomeKey, Biome biome, Set<BiomeDictionary.Type> types, SpawnReason reason) {
        if (types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            return new String[]{"gray", "albino"};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"red"};
        }
        return new String[]{"gray", "red", "albino"};
    }

    @Override
    public EntityTypeContainer<EntitySquirrel> getContainer() {
        return ModEntities.SQUIRREL;
    }

    protected boolean isAlbino() {
        return "albino".equals(this.getVariantNameOrEmpty());
    }

    public static boolean canSquirrelSpawn(EntityType<EntitySquirrel> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return MobEntity.func_223315_a(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand) || below.func_203417_a((ITag)BlockTags.field_206952_E) || below.func_203417_a((ITag)BlockTags.field_200031_h);
    }
}

