/*
 * Decompiled with CFR 0.152.
 */
package onelemonyboi.lemonlib.handlers;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class CustomEnergyStorage
extends EnergyStorage {
    Boolean canReceive = true;
    Boolean canExtract = true;

    public CustomEnergyStorage(int capacity) {
        super(capacity, capacity, capacity, 0);
    }

    public CustomEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer, maxTransfer, 0);
    }

    public CustomEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract, 0);
    }

    public CustomEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public CustomEnergyStorage(int capacity, int maxReceive, int maxExtract, Boolean canReceive, Boolean canExtract) {
        super(capacity, maxReceive, maxExtract, 0);
        this.canReceive = canReceive;
        this.canExtract = canExtract;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74768_a("energy", this.energy);
        return nbt;
    }

    public void read(CompoundNBT nbt) {
        this.setEnergy(nbt.func_74762_e("energy"));
    }

    public boolean canExtract() {
        return this.canExtract;
    }

    public boolean canReceive() {
        return this.canReceive;
    }

    public void setCanExtract(Boolean bool) {
        this.canExtract = bool;
    }

    public void setCanReceive(Boolean bool) {
        this.canReceive = bool;
    }

    public void setMaxExtract(Integer num) {
        this.maxExtract = num;
    }

    public void setMaxRecieve(Integer num) {
        this.maxReceive = num;
    }

    public int produceEnergy(int produce) {
        int energyRecieved = Math.min(this.capacity - this.energy, produce);
        this.energy += energyRecieved;
        return energyRecieved;
    }

    public int consumeEnergy(int consume) {
        int energyOutput = Math.min(this.energy, consume);
        this.energy -= energyOutput;
        return energyOutput;
    }

    public int simulateProduceEnergy(int produce) {
        return Math.min(this.capacity - this.energy, produce);
    }

    public int simulateConsumeEnergy(int consume) {
        return Math.min(this.energy, consume);
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void outputToSide(World world, BlockPos pos, Direction side, int max) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        if (te == null) {
            return;
        }
        LazyOptional opt = te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        IEnergyStorage ies = (IEnergyStorage)opt.orElse(null);
        if (ies == null) {
            return;
        }
        int ext = this.consumeEnergy(max);
        int putBack = ext - ies.receiveEnergy(ext, false);
        this.produceEnergy(putBack);
    }

    public void inputFromSide(World world, BlockPos pos, Direction side, int max) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        if (te == null) {
            return;
        }
        LazyOptional opt = te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        IEnergyStorage ies = (IEnergyStorage)opt.orElse(null);
        if (ies == null) {
            return;
        }
        int ext = ies.extractEnergy(max, false);
        int putBack = ext - this.produceEnergy(ext);
        ies.receiveEnergy(putBack, false);
    }

    @Deprecated
    public int receiveEnergy(int recieve, boolean simulate) {
        if (simulate) {
            return Math.min(this.capacity - this.energy, Math.min(this.maxReceive, recieve));
        }
        int energyRecieved = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, recieve));
        this.energy += energyRecieved;
        return energyRecieved;
    }

    @Deprecated
    public int extractEnergy(int extract, boolean simulate) {
        if (simulate) {
            return Math.min(this.maxExtract, Math.min(this.energy, extract));
        }
        int energyExtracted = Math.min(this.maxExtract, Math.min(this.energy, extract));
        this.energy -= energyExtracted;
        return energyExtracted;
    }

    public String toString() {
        return this.getEnergyStored() + "/" + this.getMaxEnergyStored();
    }

    public int machineConsume(int consume) {
        int reset = this.maxExtract;
        this.setMaxExtract(Integer.MAX_VALUE);
        int returnVal = this.consumeEnergy(consume);
        this.setMaxExtract(reset);
        return returnVal;
    }

    public int machineProduce(int recieve) {
        int reset = this.maxReceive;
        this.setMaxRecieve(Integer.MAX_VALUE);
        int returnVal = this.produceEnergy(recieve);
        this.setMaxRecieve(reset);
        return returnVal;
    }

    public Boolean checkedMachineConsume(int consume) {
        if (this.simulateConsumeEnergy(consume) == consume) {
            this.machineConsume(consume);
            return true;
        }
        return false;
    }

    public Boolean checkedMachineProduce(int consume) {
        if (this.simulateProduceEnergy(consume) == consume) {
            this.machineProduce(consume);
            return true;
        }
        return false;
    }
}

