/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.shape;

import com.refinedmods.refinedpipes.item.AttachmentItem;
import com.refinedmods.refinedpipes.network.pipe.attachment.AttachmentFactory;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCacheEntry;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeFactory;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeProps;
import com.refinedmods.refinedpipes.tile.PipeTileEntity;
import com.refinedmods.refinedpipes.util.Raytracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.tuple.Pair;

public class PipeShapeCache {
    private static final ResourceLocation[] NO_ATTACHMENT_STATE = new ResourceLocation[Direction.values().length];
    private final PipeShapeFactory shapeFactory;
    private final List<AxisAlignedBB> attachmentShapes = new ArrayList<AxisAlignedBB>();
    private final Map<PipeShapeCacheEntry, VoxelShape> cache = new HashMap<PipeShapeCacheEntry, VoxelShape>();

    public PipeShapeCache(PipeShapeFactory shapeFactory) {
        this.shapeFactory = shapeFactory;
        this.attachmentShapes.add(PipeShapeProps.NORTH_ATTACHMENT_SHAPE.func_197752_a());
        this.attachmentShapes.add(PipeShapeProps.EAST_ATTACHMENT_SHAPE.func_197752_a());
        this.attachmentShapes.add(PipeShapeProps.SOUTH_ATTACHMENT_SHAPE.func_197752_a());
        this.attachmentShapes.add(PipeShapeProps.WEST_ATTACHMENT_SHAPE.func_197752_a());
        this.attachmentShapes.add(PipeShapeProps.UP_ATTACHMENT_SHAPE.func_197752_a());
        this.attachmentShapes.add(PipeShapeProps.DOWN_ATTACHMENT_SHAPE.func_197752_a());
    }

    public VoxelShape getShape(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        Item inHand;
        VoxelShape shape = this.createShapeIfNeeded(state, world, pos);
        if (ctx.getEntity() instanceof PlayerEntity && (inHand = ((PlayerEntity)ctx.getEntity()).func_184614_ca().func_77973_b()) instanceof AttachmentItem) {
            shape = this.addFakeAttachmentShape(state.func_177230_c(), pos, ctx.getEntity(), shape, ((AttachmentItem)inHand).getFactory());
        }
        return shape;
    }

    private VoxelShape addFakeAttachmentShape(Block block, BlockPos pos, Entity entity, VoxelShape shape, AttachmentFactory type) {
        if (!type.canPlaceOnPipe(block)) {
            return shape;
        }
        Pair<Vector3d, Vector3d> vec = Raytracer.getVectors(entity);
        Raytracer.AdvancedRayTraceResult<BlockRayTraceResult> result = Raytracer.collisionRayTrace(pos, (Vector3d)vec.getLeft(), (Vector3d)vec.getRight(), this.attachmentShapes);
        if (result != null) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)result.bounds));
        }
        return shape;
    }

    private VoxelShape createShapeIfNeeded(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        ResourceLocation[] attachmentState = tile instanceof PipeTileEntity ? ((PipeTileEntity)tile).getAttachmentManager().getState() : NO_ATTACHMENT_STATE;
        PipeShapeCacheEntry entry = new PipeShapeCacheEntry(state, attachmentState);
        return this.cache.computeIfAbsent(entry, e -> this.shapeFactory.createShape(e.getState(), e.getAttachmentState()));
    }
}

