/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneDamageBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.net.MessageControlPlane;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class EntityPlaneControlBase
extends EntityPlaneDamageBase {
    private static final DataParameter<Float> ENGINE_SPEED = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> STARTED = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> START_TIME = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> THRUST_POSITIVE = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> THRUST_NEGATIVE = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LEFT = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIGHT = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> UP = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DOWN = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BRAKE = EntityDataManager.func_187226_a(EntityPlaneControlBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final double MAX_ENGINE_SPEED = 1.5;
    public static final double ENGINE_ACCELERATION = 0.005;
    public static final double BRAKE_POWER = 0.012;
    private boolean onGroundLast;
    private boolean onGroundLast2;

    public EntityPlaneControlBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getStartTime() > this.getTimeToStart() && !this.isStarted() && this.canEngineBeStarted()) {
            this.setStarted(true);
        }
        if (this.isStarted() && !this.canEngineBeStarted()) {
            this.setStarted(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isStarted()) {
                if (this.isThrustPositive()) {
                    this.setEngineSpeed(Math.min(this.getEngineSpeed() + 0.025f, 1.0f));
                } else if (this.isThrustNegative()) {
                    this.setEngineSpeed(Math.max(this.getEngineSpeed() - 0.025f, 0.0f));
                }
            } else {
                this.setEngineSpeed(0.0f);
            }
        }
        this.controlPlane();
        this.handleRotation();
    }

    public boolean canEngineBeStarted() {
        return !this.isStarted() || !(this.getPlaneDamage() >= 100.0f);
    }

    public int getTimeToStart() {
        int time = 40;
        time = (int)((float)time + (float)((int)this.getPlaneDamage()) / 2.0f);
        return time;
    }

    private void handleRotation() {
        double speed = this.func_213322_ci().func_72433_c();
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.0) {
            rotationSpeed = MathHelper.func_76135_e((float)(0.5f / (float)Math.pow(speed, 2.0)));
            rotationSpeed = MathHelper.func_76131_a((float)rotationSpeed, (float)1.0f, (float)5.0f);
        }
        this.deltaRotation = 0.0f;
        rotationSpeed = Math.abs(rotationSpeed);
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.field_70177_z += this.deltaRotation;
        float delta = Math.abs(this.field_70177_z - this.field_70126_B);
        while (this.field_70177_z > 180.0f) {
            this.field_70177_z -= 360.0f;
            this.field_70126_B = this.field_70177_z - delta;
        }
        while (this.field_70177_z <= -180.0f) {
            this.field_70177_z += 360.0f;
            this.field_70126_B = delta + this.field_70177_z;
        }
        if (this.isUp()) {
            this.field_70125_A -= 1.0f;
        } else if (this.isDown()) {
            this.field_70125_A += 1.0f;
        }
        this.field_70125_A = Math.max(this.field_70125_A, -90.0f);
        this.field_70125_A = Math.min(this.field_70125_A, 90.0f);
        float groundPitchTolerance = 7.0f;
        if (this.isCollidedVertical()) {
            if (this.field_70125_A > 0.0f) {
                this.field_70125_A -= 10.0f;
                if (this.field_70125_A < 0.0f) {
                    this.field_70125_A = 0.0f;
                }
            }
            if (this.field_70125_A < -groundPitchTolerance) {
                this.field_70125_A += 10.0f;
                if (this.field_70125_A > -groundPitchTolerance) {
                    this.field_70125_A = -groundPitchTolerance;
                }
            }
        }
    }

    private void controlPlane() {
        double newVerticalMotion;
        double newHorizontalMotion;
        double motionDifference;
        double damage;
        if (!this.func_184207_aI()) {
            this.setThrustPositive(false);
            this.setThrustNegative(false);
            this.setLeft(false);
            this.setRight(false);
            this.setUp(false);
            this.setDown(false);
            this.setBrake(true);
            this.setStartTime(0);
        }
        Vector3d motionVector = this.func_213322_ci();
        double verticalMotion = Math.abs(motionVector.field_72448_b);
        double horizontalMotion = this.getHorizontalMotion(motionVector);
        float engineSpeed = this.getEngineSpeed();
        if (this.isCollidedVertical()) {
            double maxEngineSpeed;
            double speed = this.func_213322_ci().func_72433_c();
            if (speed < (maxEngineSpeed = 1.5 * (double)engineSpeed)) {
                speed = Math.min(speed + (double)engineSpeed * 0.005, maxEngineSpeed);
            }
            if (this.isBrake()) {
                speed = EntityPlaneControlBase.decreaseToZero(speed, 1.0 / (speed + 1.0) * 0.012);
            }
            if (engineSpeed <= 0.0f) {
                speed = EntityPlaneControlBase.decreaseToZero(speed, 0.002);
            }
            Vector3d motion = this.func_70040_Z().func_72432_b().func_186678_a(speed).func_216372_d(1.0, 0.0, 1.0);
            this.func_213317_d(motion);
            if (speed > 0.0) {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            }
        } else {
            double speed;
            double fallSpeed = this.getFallSpeed();
            Vector3d lookVec = this.func_70040_Z();
            float modifiedPitch = (this.field_70125_A < 0.0f ? this.field_70125_A : Math.min(this.field_70125_A * 1.5f, 90.0f)) - 5.0f;
            float pitch = modifiedPitch * ((float)Math.PI / 180);
            double horizontalLook = Math.sqrt(lookVec.field_72450_a * lookVec.field_72450_a + lookVec.field_72449_c * lookVec.field_72449_c);
            double lookLength = lookVec.func_72433_c();
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            cosPitch = (float)((double)cosPitch * (double)cosPitch * Math.min(1.0, lookLength / 0.4));
            motionVector = this.func_213322_ci().func_72441_c(0.0, fallSpeed * (-1.0 + (double)cosPitch * 0.75), 0.0);
            if (motionVector.field_72448_b < 0.0 && horizontalLook > 0.0) {
                double down = motionVector.field_72448_b * -0.1 * (double)cosPitch;
                motionVector = motionVector.func_72441_c(lookVec.field_72450_a * down / horizontalLook, down, lookVec.field_72449_c * down / horizontalLook);
            }
            if (pitch < 0.0f && horizontalLook > 0.0) {
                double d13 = horizontalMotion * (double)(-MathHelper.func_76126_a((float)pitch)) * 0.04;
                motionVector = motionVector.func_72441_c(-lookVec.field_72450_a * d13 / horizontalLook, d13 * 3.2, -lookVec.field_72449_c * d13 / horizontalLook);
            }
            if (horizontalLook > 0.0) {
                motionVector = motionVector.func_72441_c((lookVec.field_72450_a / horizontalLook * horizontalMotion - motionVector.field_72450_a) * 0.1, 0.0, (lookVec.field_72449_c / horizontalLook * horizontalMotion - motionVector.field_72449_c) * 0.1);
            }
            if ((speed = (motionVector = motionVector.func_216372_d(0.99, 0.98, 0.99)).func_72433_c()) < 1.5 * (double)engineSpeed) {
                double addSpeed = 0.0;
                if (speed + (addSpeed += (double)engineSpeed * 0.005 * 4.0) > 1.5 * (double)engineSpeed) {
                    addSpeed = 1.5 * (double)engineSpeed - speed;
                }
                if (addSpeed < 0.0) {
                    addSpeed = 0.0;
                }
                if (this.getPitchPercentage() < -0.25f) {
                    addSpeed = 0.0;
                }
                Vector3d addVec = this.func_70040_Z().func_72432_b().func_186678_a(addSpeed);
                motionVector = motionVector.func_178787_e(new Vector3d(addVec.field_72450_a, 0.0, addVec.field_72449_c));
            }
            if (this.isStalling(motionVector)) {
                motionVector = motionVector.func_216369_h(new Vector3d(0.975, 1.025, 0.975));
            }
            this.func_213317_d(motionVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isCollidedHorizontal() && (damage = (motionDifference = horizontalMotion - (newHorizontalMotion = this.getHorizontalMotion(this.func_213322_ci()))) * 100.0 - 12.0) > 0.0) {
            this.damagePlane(damage, true);
            System.out.println("dmg: " + damage);
        }
        if (this.isCollidedVertical() && (damage = (motionDifference = verticalMotion - (newVerticalMotion = Math.abs(this.func_213322_ci().field_72448_b))) * 100.0 - 10.0) > 0.0) {
            this.damagePlane(damage, false);
            System.out.println("dmg vert: " + damage);
        }
    }

    protected boolean isStalling(Vector3d motionVector) {
        return motionVector.func_216372_d(1.0, 0.0, 1.0).func_72433_c() / 4.0 < -motionVector.field_72448_b;
    }

    public abstract double getFallSpeed();

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        if (horizontal && damage > 5.0 || damage > 20.0) {
            this.setStarted(false);
        }
    }

    public boolean isCollidedVertical() {
        boolean last = this.onGroundLast;
        boolean last2 = this.onGroundLast2;
        this.onGroundLast2 = this.onGroundLast;
        this.onGroundLast = this.field_70122_E;
        return last || last2 || this.field_70122_E;
    }

    public boolean isCollidedHorizontal() {
        return this.field_70123_F;
    }

    public double getHorizontalMotion(Vector3d vec3d) {
        return Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
    }

    public double getAngle(Vector3d vec1, Vector3d vec2) {
        return Math.acos(Math.abs(vec1.func_72430_b(vec2)) / (vec1.func_72433_c() * vec2.func_72433_c()));
    }

    private static double decreaseToZero(double num, double amount) {
        double erg;
        if (num < 0.0) {
            erg = num + amount;
            if (erg > 0.0) {
                erg = 0.0;
            }
        } else {
            erg = num - amount;
            if (erg < 0.0) {
                erg = 0.0;
            }
        }
        return erg;
    }

    public float getPitchPercentage() {
        return this.field_70125_A / 90.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STARTED, (Object)false);
        this.field_70180_af.func_187214_a(START_TIME, (Object)0);
        this.field_70180_af.func_187214_a(ENGINE_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(THRUST_POSITIVE, (Object)false);
        this.field_70180_af.func_187214_a(THRUST_NEGATIVE, (Object)false);
        this.field_70180_af.func_187214_a(LEFT, (Object)false);
        this.field_70180_af.func_187214_a(RIGHT, (Object)false);
        this.field_70180_af.func_187214_a(UP, (Object)false);
        this.field_70180_af.func_187214_a(DOWN, (Object)false);
        this.field_70180_af.func_187214_a(BRAKE, (Object)false);
    }

    public void updateControls(boolean up, boolean down, boolean thrustPos, boolean thrustNeg, boolean left, boolean right, boolean braking, boolean starting) {
        boolean needsUpdate = false;
        if (this.isThrustPositive() != thrustPos) {
            this.setThrustPositive(thrustPos);
            needsUpdate = true;
        }
        if (this.isThrustNegative() != thrustNeg) {
            this.setThrustNegative(thrustNeg);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.isUp() != up) {
            this.setUp(up);
            needsUpdate = true;
        }
        if (this.isDown() != down) {
            this.setDown(down);
            needsUpdate = true;
        }
        if (this.isBrake() != braking) {
            this.setBrake(braking);
            needsUpdate = true;
        }
        if (starting) {
            if (this.isStarted()) {
                if (this.getStartTime() <= 0) {
                    this.setStarted(false);
                }
            } else {
                this.setStartTime(this.getStartTime() + 1);
            }
            needsUpdate = true;
        } else if (this.getStartTime() > 0) {
            this.setStartTime(0);
            needsUpdate = true;
        }
        if (this.field_70170_p.field_72995_K && needsUpdate) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageControlPlane(up, down, thrustPos, thrustNeg, left, right, braking, starting));
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("EngineSpeed", this.getEngineSpeed());
        compound.func_74757_a("Started", this.isStarted());
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setEngineSpeed(compound.func_74760_g("EngineSpeed"));
        ((EntityPlaneSoundBase)this).setStarted(compound.func_74767_n("Started"), false);
    }

    public boolean isStarted() {
        return (Boolean)this.field_70180_af.func_187225_a(STARTED);
    }

    public void setStarted(boolean started) {
        this.field_70180_af.func_187227_b(STARTED, (Object)started);
    }

    public boolean isBrake() {
        return (Boolean)this.field_70180_af.func_187225_a(BRAKE);
    }

    public void setBrake(boolean breaking) {
        this.field_70180_af.func_187227_b(BRAKE, (Object)breaking);
    }

    public boolean isThrustPositive() {
        return (Boolean)this.field_70180_af.func_187225_a(THRUST_POSITIVE);
    }

    public void setThrustPositive(boolean thrustPositive) {
        this.field_70180_af.func_187227_b(THRUST_POSITIVE, (Object)thrustPositive);
    }

    public boolean isThrustNegative() {
        return (Boolean)this.field_70180_af.func_187225_a(THRUST_NEGATIVE);
    }

    public void setThrustNegative(boolean thrustNegative) {
        this.field_70180_af.func_187227_b(THRUST_NEGATIVE, (Object)thrustNegative);
    }

    public boolean isLeft() {
        return (Boolean)this.field_70180_af.func_187225_a(LEFT);
    }

    public void setLeft(boolean left) {
        this.field_70180_af.func_187227_b(LEFT, (Object)left);
    }

    public boolean isRight() {
        return (Boolean)this.field_70180_af.func_187225_a(RIGHT);
    }

    public void setRight(boolean right) {
        this.field_70180_af.func_187227_b(RIGHT, (Object)right);
    }

    public boolean isUp() {
        return (Boolean)this.field_70180_af.func_187225_a(UP);
    }

    public void setUp(boolean up) {
        this.field_70180_af.func_187227_b(UP, (Object)up);
    }

    public boolean isDown() {
        return (Boolean)this.field_70180_af.func_187225_a(DOWN);
    }

    public void setDown(boolean down) {
        this.field_70180_af.func_187227_b(DOWN, (Object)down);
    }

    public float getEngineSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ENGINE_SPEED)).floatValue();
    }

    public void setEngineSpeed(float speed) {
        this.field_70180_af.func_187227_b(ENGINE_SPEED, (Object)Float.valueOf(speed));
    }

    public int getStartTime() {
        return (Integer)this.field_70180_af.func_187225_a(START_TIME);
    }

    public void setStartTime(int startTime) {
        this.field_70180_af.func_187227_b(START_TIME, (Object)startTime);
    }
}

