/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.plane.corelib.client.obj.OBJEntityRenderer;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.math.vector.Vector3f;

public abstract class AbstractPlaneModel<T extends EntityPlaneSoundBase>
extends OBJEntityRenderer<T> {
    public AbstractPlaneModel(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(T plane, float yRot, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light) {
        super.func_225623_a_(plane, yRot, partialTicks, matrixStack, buffer, light);
        if (plane.func_145818_k_()) {
            String name = this.trimName(plane.func_200201_e().getString(), 0.02f, 1.0f);
            this.drawName(plane, name, matrixStack, buffer, partialTicks, yRot, light, true);
            this.drawName(plane, name, matrixStack, buffer, partialTicks, yRot, light, false);
        }
    }

    protected String trimName(String name, float textScale, float maxLength) {
        while ((float)this.func_76983_a().func_78256_a(name) * textScale > maxLength) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected void drawName(T plane, String txt, MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks, float yRot, int light, boolean left) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-yRot));
        float xRot = ((EntityPlaneSoundBase)((Object)plane)).field_70127_C + (((EntityPlaneSoundBase)((Object)plane)).field_70125_A - ((EntityPlaneSoundBase)((Object)plane)).field_70127_C) * partialTicks;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(xRot));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
        this.translateName(plane, matrixStack, left);
        int textWidth = this.func_76983_a().func_78256_a(txt);
        float textScale = 0.02f;
        matrixStack.func_227861_a_((double)(-(textScale * (float)textWidth) / 2.0f), 0.0, 0.0);
        matrixStack.func_227862_a_(textScale, textScale, textScale);
        this.func_76983_a().func_228079_a_(txt, 0.0f, 0.0f, 0xFFFFFF, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, light);
        matrixStack.func_227865_b_();
    }

    protected abstract void translateName(T var1, MatrixStack var2, boolean var3);
}

