/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.nio.IntBuffer;
import net.optifine.Config;
import net.optifine.render.MultiTextureData;
import net.optifine.render.SpriteRenderData;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;

public class MultiTextureRenderer {
    private static IntBuffer bufferPositions = Config.createDirectIntBuffer(1024);
    private static IntBuffer bufferCounts = Config.createDirectIntBuffer(1024);
    private static boolean shaders;

    public static void draw(int drawMode, MultiTextureData multiTextureData) {
        shaders = Config.isShaders();
        SpriteRenderData[] srds = multiTextureData.getSpriteRenderDatas();
        for (int i = 0; i < srds.length; ++i) {
            SpriteRenderData srd = srds[i];
            MultiTextureRenderer.draw(drawMode, srd);
        }
    }

    private static void draw(int drawMode, SpriteRenderData srd) {
        ekc sprite = srd.getSprite();
        int[] positions = srd.getPositions();
        int[] counts = srd.getCounts();
        dem.s((int)sprite.glSpriteTextureId);
        if (shaders) {
            int normalTex = sprite.spriteNormal != null ? sprite.spriteNormal.glSpriteTextureId : 0;
            int specularTex = sprite.spriteSpecular != null ? sprite.spriteSpecular.glSpriteTextureId : 0;
            ekb at = sprite.m();
            ShadersTex.bindNSTextures(normalTex, specularTex, at.isNormalBlend(), at.isSpecularBlend(), at.isMipmaps());
            if (Shaders.uniform_spriteBounds.isDefined()) {
                Shaders.uniform_spriteBounds.setValue(sprite.h(), sprite.j(), sprite.i(), sprite.k());
            }
        }
        if (bufferPositions.capacity() < positions.length) {
            int size = afm.c((int)positions.length);
            bufferPositions = Config.createDirectIntBuffer(size);
            bufferCounts = Config.createDirectIntBuffer(size);
        }
        bufferPositions.clear();
        bufferCounts.clear();
        bufferPositions.put(positions);
        bufferCounts.put(counts);
        bufferPositions.flip();
        bufferCounts.flip();
        dem.glMultiDrawArrays((int)drawMode, (IntBuffer)bufferPositions, (IntBuffer)bufferCounts);
    }
}

