/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class DeskBlock
extends FurnitureHorizontalWaterloggedBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);
    private MaterialType materialType;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public DeskBlock(AbstractBlock.Properties properties, MaterialType materialType) {
        super(properties);
        this.materialType = materialType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)((Object)Type.SINGLE)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] DESK_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] DESK_BACK = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] DESK_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] DESK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            Type type = (Type)((Object)state.func_177229_b(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(DESK_TOP[direction.func_176736_b()]);
            shapes.add(DESK_BACK[direction.func_176736_b()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(DESK_LEFT[direction.func_176736_b()]);
                    shapes.add(DESK_RIGHT[direction.func_176736_b()]);
                    break;
                }
                case LEFT: {
                    shapes.add(DESK_LEFT[direction.func_176736_b()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(DESK_RIGHT[direction.func_176736_b()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        Direction dir = (Direction)state.func_177229_b((Property)DIRECTION);
        boolean left = this.isDesk(world, pos, dir.func_176735_f(), dir);
        boolean right = this.isDesk(world, pos, dir.func_176746_e(), dir);
        if (left && right) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isDesk(IWorld world, BlockPos source, Direction checkDirection, Direction tableDirection) {
        BlockState state = world.func_180495_p(source.func_177972_a(checkDirection));
        return state.func_177230_c() instanceof DeskBlock && ((DeskBlock)state.func_177230_c()).materialType == this.materialType && state.func_177229_b((Property)DIRECTION) == tableDirection;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TYPE});
    }

    public static enum MaterialType {
        OAK,
        BIRCH,
        SPRUCE,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        CRIMSON,
        WARPED,
        STONE,
        GRANITE,
        DIORITE,
        ANDESITE,
        STRIPPED_OAK,
        STRIPPED_BIRCH,
        STRIPPED_SPRUCE,
        STRIPPED_JUNGLE,
        STRIPPED_ACACIA,
        STRIPPED_DARK_OAK,
        STRIPPED_CRIMSON,
        STRIPPED_WARPED;

    }

    public static enum Type implements IStringSerializable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String func_176610_l() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

