/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.entity.EntityPlaneInventoryBase;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;

public abstract class EntityPlaneWheelBase
extends EntityPlaneInventoryBase {
    private int ticksSinceLiftOff;
    private int ticksSinceEngineOff = 100000;
    private float wheelRotation;
    private float propellerRotation;
    private static final float WHEEL_ROTATION = 240.0f;
    private static final float PROPELLER_ROTATION = 240.0f;

    public EntityPlaneWheelBase(EntityType type, World world) {
        super(type, world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateRotation();
    }

    public void updateRotation() {
        if (!this.isCollidedVertical()) {
            ++this.ticksSinceLiftOff;
        } else if (this.ticksSinceLiftOff > 0) {
            this.ticksSinceLiftOff = 0;
        }
        if (!this.isStarted() && this.getStartTime() <= 0) {
            ++this.ticksSinceEngineOff;
        } else if (this.ticksSinceEngineOff > 0) {
            this.ticksSinceEngineOff = 0;
        }
        this.wheelRotation += this.getWheelRotationAmount();
        this.propellerRotation += this.getPropellerRotationAmount();
    }

    public float getWheelRotation(float partialTicks) {
        return this.wheelRotation + this.getWheelRotationAmount() * partialTicks;
    }

    public float getPropellerRotation(float partialTicks) {
        return this.propellerRotation + this.getPropellerRotationAmount() * partialTicks;
    }

    public float getWheelRotationAmount() {
        float amount = 240.0f * (float)this.func_213322_ci().func_72433_c();
        if (!this.isCollidedVertical()) {
            amount = Math.max(amount - (float)this.ticksSinceLiftOff, 0.0f);
        }
        return amount;
    }

    public float getPropellerRotationAmount() {
        float amount = 240.0f * (this.getEngineSpeed() + 0.35f);
        if (!this.isStarted() && this.getStartTime() <= 0) {
            amount = Math.max(amount - (float)this.ticksSinceEngineOff, 0.0f);
        }
        return amount;
    }
}

