/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityTank
extends TileEntityBase
implements IFluidHandler,
ITickableTileEntity {
    private FluidStack fluid;
    public static final int CAPACITY = 16000;
    private boolean[] sides = new boolean[Direction.values().length];
    private boolean[] sidesFluid = new boolean[Direction.values().length];

    public TileEntityTank() {
        super(Main.TANK_TILE_ENTITY_TYPE);
        this.fluid = FluidStack.EMPTY;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.synchronize();
            }
        } else {
            this.updateClientSide();
        }
        if (this.fluid.isEmpty()) {
            return;
        }
        this.checkDown();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (this.fluid.isEmpty()) {
                return;
            }
            this.checkSide(facing);
        }
    }

    public void checkSide(Direction side) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        FluidStack other = otherTank.getFluid();
        if (!other.getFluid().equals(this.fluid.getFluid()) && !other.isEmpty()) {
            return;
        }
        int dif = other.getAmount() - this.fluid.getAmount();
        if (dif >= -2) {
            return;
        }
        FluidUtil.tryFluidTransfer((IFluidHandler)otherTank, (IFluidHandler)this, (int)(-dif / 2), (boolean)true);
    }

    public void checkDown() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        FluidStack stack = FluidUtil.tryFluidTransfer((IFluidHandler)otherTank, (IFluidHandler)this, (int)Integer.MAX_VALUE, (boolean)true);
        if (stack.isEmpty()) {
            return;
        }
        if (!this.fluid.isEmpty() && this.fluid.getAmount() <= 0) {
            this.fluid = FluidStack.EMPTY;
        }
    }

    public float getFillPercent() {
        if (this.fluid.isEmpty()) {
            return 0.0f;
        }
        return (float)this.fluid.getAmount() / 16000.0f;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (!this.fluid.isEmpty() && this.fluid.getAmount() > 0) {
            CompoundNBT comp = new CompoundNBT();
            this.fluid.writeToNBT(comp);
            compound.func_218657_a("fluid", (INBT)comp);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        if (compound.func_74764_b("fluid")) {
            CompoundNBT comp = compound.func_74775_l("fluid");
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)comp);
        } else {
            this.fluid = FluidStack.EMPTY;
        }
        super.func_230337_a_(blockState, compound);
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.tank");
    }

    @Override
    public IIntArray getFields() {
        return new IntArray(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void recalculateSides() {
        for (Direction facing : Direction.values()) {
            this.sides[facing.func_176745_a()] = this.isTankConnectedCalc(facing);
            this.sidesFluid[facing.func_176745_a()] = this.isFluidConnectedCalc(facing);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isFluidConnectedCalc(Direction facing) {
        BlockState s;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fluid.isEmpty() || this.fluid.isEmpty()) {
                return false;
            }
            if (tank.fluid.getFluid().equals(this.fluid.getFluid())) {
                if (facing.equals((Object)Direction.UP)) {
                    return this.fluid.getAmount() >= 16000;
                }
                return true;
            }
        }
        if ((s = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing))).func_215686_e((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(facing))) {
            if (facing.equals((Object)Direction.UP)) {
                return this.fluid.getAmount() >= 16000;
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isTankConnectedCalc(Direction facing) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fluid.isEmpty() && this.fluid.isEmpty()) {
                return true;
            }
            if (tank.fluid.isEmpty() || this.fluid.isEmpty()) {
                return true;
            }
            return tank.fluid.getFluid().equals(this.fluid.getFluid());
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateClientSide() {
        this.recalculateSides();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTankConnectedTo(Direction facing) {
        return this.sides[facing.func_176745_a()];
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFluidConnected(Direction facing) {
        return this.sidesFluid[facing.func_176745_a()];
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int getTankCapacity(int tank) {
        return 16000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty()) {
            int amount = Math.min(resource.getAmount(), 16000);
            if (action.execute()) {
                this.fluid = new FluidStack(resource.getFluid(), amount);
                this.func_70296_d();
            }
            return amount;
        }
        if (resource.getFluid().equals(this.fluid.getFluid())) {
            int amount = Math.min(resource.getAmount(), 16000 - this.fluid.getAmount());
            if (action.execute()) {
                this.fluid.setAmount(this.fluid.getAmount() + amount);
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.fluid.getFluid().equals(resource.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.fluid.getAmount());
            Fluid f = this.fluid.getFluid();
            if (action.execute()) {
                this.fluid.setAmount(this.fluid.getAmount() - amount);
                if (this.fluid.getAmount() <= 0) {
                    this.fluid = FluidStack.EMPTY;
                }
                this.func_70296_d();
            }
            return new FluidStack(f, amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.fluid.getAmount());
        Fluid f = this.fluid.getFluid();
        if (action.execute()) {
            this.fluid.setAmount(this.fluid.getAmount() - amount);
            if (this.fluid.getAmount() <= 0) {
                this.fluid = FluidStack.EMPTY;
            }
            this.func_70296_d();
        }
        return new FluidStack(f, amount);
    }
}

