/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemCanister
extends Item {
    public ItemCanister() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ModItemGroups.TAB_CAR));
        this.setRegistryName(new ResourceLocation("car", "canister"));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195999_j().func_225608_bj_()) {
            return super.func_195939_a(context);
        }
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        TileEntity te = state.func_177230_c().equals((Object)ModBlocks.FUEL_STATION_TOP) ? context.func_195991_k().func_175625_s(context.func_195995_a().func_177977_b()) : context.func_195991_k().func_175625_s(context.func_195995_a());
        if (te == null) {
            return super.func_195939_a(context);
        }
        if (te instanceof TileEntityGasStation) {
            TileEntityGasStation fuel = (TileEntityGasStation)te;
            boolean success = ItemCanister.fillCanister(context.func_195999_j().func_184586_b(context.func_221531_n()), fuel);
            if (success) {
                ModSounds.playSound(SoundEvents.field_187621_J, context.func_195991_k(), context.func_195995_a(), null, SoundCategory.BLOCKS);
            }
            return ActionResultType.SUCCESS;
        }
        if (te instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)te;
            boolean success = ItemCanister.fuelFluidHandler(context.func_195999_j().func_184586_b(context.func_221531_n()), handler);
            if (success) {
                ModSounds.playSound(SoundEvents.field_187621_J, context.func_195991_k(), context.func_195995_a(), null, SoundCategory.BLOCKS);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            CompoundNBT comp = stack.func_77978_p();
            if (comp.func_74764_b("fuel")) {
                CompoundNBT fuel = comp.func_74775_l("fuel");
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fuel);
                if (fluidStack == null || fluidStack.isEmpty()) {
                    this.addInfo("-", 0, tooltip);
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                    return;
                }
                this.addInfo(fluidStack.getDisplayName().getString(), fluidStack.getAmount(), tooltip);
                super.func_77624_a(stack, worldIn, tooltip, flagIn);
                return;
            }
            this.addInfo("-", 0, tooltip);
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            return;
        }
        this.addInfo("-", 0, tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private void addInfo(String fluid, int amount, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent("canister.fluid", new Object[]{new StringTextComponent(fluid).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("canister.amount", new Object[]{new StringTextComponent(String.valueOf(amount)).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
    }

    public static boolean fillCanister(ItemStack canister, IFluidHandler handler) {
        CompoundNBT comp = canister.func_196082_o();
        FluidStack fluid = null;
        if (comp.func_74764_b("fuel")) {
            fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)comp.func_74775_l("fuel"));
        }
        int maxAmount = (Integer)Main.SERVER_CONFIG.canisterMaxFuel.get();
        if (fluid != null) {
            maxAmount = (Integer)Main.SERVER_CONFIG.canisterMaxFuel.get() - fluid.getAmount();
        }
        if (maxAmount <= 0) {
            return false;
        }
        FluidStack resultSim = handler.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (resultSim.getAmount() <= 0) {
            return false;
        }
        if (fluid != null && !fluid.isEmpty() && !resultSim.getFluid().equals(fluid.getFluid())) {
            return false;
        }
        FluidStack result = handler.drain(maxAmount, IFluidHandler.FluidAction.EXECUTE);
        if (result.isEmpty()) {
            return false;
        }
        if (fluid == null || fluid.isEmpty()) {
            comp.func_218657_a("fuel", (INBT)result.writeToNBT(new CompoundNBT()));
            return true;
        }
        if (result.getFluid().equals(fluid.getFluid())) {
            fluid.setAmount(fluid.getAmount() + result.getAmount());
            comp.func_218657_a("fuel", (INBT)fluid.writeToNBT(new CompoundNBT()));
        }
        return true;
    }

    public static boolean fuelFluidHandler(ItemStack canister, IFluidHandler handler) {
        if (!canister.func_77942_o()) {
            return false;
        }
        CompoundNBT comp = canister.func_77978_p();
        if (!comp.func_74764_b("fuel")) {
            return false;
        }
        CompoundNBT fluid = comp.func_74775_l("fuel");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluid);
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        int fueledAmount = handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        stack.setAmount(stack.getAmount() - fueledAmount);
        if (stack.getAmount() <= 0) {
            comp.func_218657_a("fuel", (INBT)new CompoundNBT());
            return true;
        }
        CompoundNBT f = new CompoundNBT();
        stack.writeToNBT(f);
        comp.func_218657_a("fuel", (INBT)f);
        return true;
    }
}

