/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelVoidWormBody;
import com.github.alexthe666.alexsmobs.client.model.ModelVoidWormTail;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class RenderVoidWormBody
extends LivingRenderer<EntityVoidWormPart, EntityModel<EntityVoidWormPart>> {
    private static final ResourceLocation TEXTURE_BODY = new ResourceLocation("alexsmobs:textures/entity/void_worm_body.png");
    private static final ResourceLocation TEXTURE_BODY_HURT = new ResourceLocation("alexsmobs:textures/entity/void_worm_body_hurt.png");
    private static final ResourceLocation TEXTURE_BODY_GLOW = new ResourceLocation("alexsmobs:textures/entity/void_worm_body_glow.png");
    private static final ResourceLocation TEXTURE_TAIL = new ResourceLocation("alexsmobs:textures/entity/void_worm_tail.png");
    private static final ResourceLocation TEXTURE_TAIL_HURT = new ResourceLocation("alexsmobs:textures/entity/void_worm_tail_hurt.png");
    private static final ResourceLocation TEXTURE_TAIL_GLOW = new ResourceLocation("alexsmobs:textures/entity/void_worm_tail_glow.png");
    private ModelVoidWormBody bodyModel = new ModelVoidWormBody();
    private ModelVoidWormTail tailModel = new ModelVoidWormTail();

    public RenderVoidWormBody(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelVoidWormBody(), 1.0f);
        this.func_177094_a(new LayerGlow(this));
    }

    public boolean shouldRender(EntityVoidWormPart worm, ClippingHelper camera, double camX, double camY, double camZ) {
        return worm.getPortalTicks() <= 0 && super.func_225626_a_((Entity)worm, camera, camX, camY, camZ);
    }

    public ResourceLocation getEntityTexture(EntityVoidWormPart entity) {
        if (entity.isHurt()) {
            return entity.isTail() ? TEXTURE_TAIL_HURT : TEXTURE_BODY_HURT;
        }
        return entity.isTail() ? TEXTURE_TAIL : TEXTURE_BODY;
    }

    protected void applyRotations(EntityVoidWormPart entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        Pose pose = entityLiving.func_213283_Z();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityLiving.getWormYaw(partialTicks)));
        }
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * this.func_77037_a(entityLiving)));
        }
    }

    protected void preRenderCallback(EntityVoidWormPart entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        this.field_77045_g = entitylivingbaseIn.isTail() ? this.tailModel : this.bodyModel;
        matrixStackIn.func_227862_a_(entitylivingbaseIn.getWormScale(), entitylivingbaseIn.getWormScale(), entitylivingbaseIn.getWormScale());
    }

    protected boolean canRenderName(EntityVoidWormPart entity) {
        return super.func_177070_b((LivingEntity)entity) && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }

    class LayerGlow
    extends LayerRenderer<EntityVoidWormPart, EntityModel<EntityVoidWormPart>> {
        public LayerGlow(RenderVoidWormBody render) {
            super((IEntityRenderer)render);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityVoidWormPart worm, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!worm.isHurt()) {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(AMRenderTypes.getEyesAlphaEnabled(worm.isTail() ? TEXTURE_TAIL_GLOW : TEXTURE_BODY_GLOW));
                float alpha = (float)MathHelper.func_151237_a((double)(((double)worm.func_110143_aJ() - worm.getHealthThreshold()) / ((double)worm.func_110138_aP() - worm.getHealthThreshold())), (double)0.0, (double)1.0);
                this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 240, LivingRenderer.func_229117_c_((LivingEntity)worm, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

