/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityGazelle
extends AnimalEntity
implements IAnimatedEntity,
IHerdPanic {
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation ANIMATION_FLICK_EARS = Animation.create((int)20);
    public static final Animation ANIMATION_FLICK_TAIL = Animation.create((int)14);
    public static final Animation ANIMATION_EAT_GRASS = Animation.create((int)30);
    private boolean hasSpedUp = false;
    private int revengeCooldown = 0;
    private static final DataParameter<Boolean> RUNNING = EntityDataManager.func_187226_a(EntityGazelle.class, (IDataSerializer)DataSerializers.field_187198_h);

    protected EntityGazelle(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimalAIHerdPanic((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 100, 1.0, 25, 7));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.GAZELLE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.GAZELLE_HURT;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.gazelleSpawnRolls, this.func_70681_au(), spawnReasonIn) && super.func_213380_a(worldIn, spawnReasonIn);
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.func_70681_au().nextInt(150);
            List list = this.field_70170_p.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(range, range / 2.0, range));
            for (EntityGazelle gaz : list) {
                gaz.revengeCooldown = fleeTime;
            }
        }
        return prev;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RUNNING, (Object)false);
    }

    public boolean isRunning() {
        return (Boolean)this.field_70180_af.func_187225_a(RUNNING);
    }

    public void setRunning(boolean running) {
        this.field_70180_af.func_187227_b(RUNNING, (Object)running);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151015_O;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && this.func_70681_au().nextInt(70) == 0 && (this.func_70643_av() == null || this.func_70032_d((Entity)this.func_70643_av()) > 30.0f)) {
            if (this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_196658_i) && this.func_70681_au().nextInt(3) == 0) {
                this.setAnimation(ANIMATION_EAT_GRASS);
            } else {
                this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_FLICK_EARS : ANIMATION_FLICK_TAIL);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.revengeCooldown >= 0) {
                --this.revengeCooldown;
            }
            if (this.revengeCooldown == 0 && this.func_70643_av() != null) {
                this.func_70604_c(null);
            }
            this.setRunning(this.revengeCooldown > 0);
            if (this.isRunning() && !this.hasSpedUp) {
                this.hasSpedUp = true;
                this.func_70031_b(true);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.475f);
            }
            if (!this.isRunning() && this.hasSpedUp) {
                this.hasSpedUp = false;
                this.func_70031_b(false);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("GazelleRunning", this.isRunning());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRunning(compound.func_74767_n("GazelleRunning"));
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_FLICK_EARS, ANIMATION_FLICK_TAIL, ANIMATION_EAT_GRASS};
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.GAZELLE.func_200721_a((World)p_241840_1_);
    }

    @Override
    public void onPanic() {
    }

    @Override
    public boolean canPanic() {
        return true;
    }
}

