/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityHummingbird;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HummingbirdAIPollinate
extends MoveToBlockGoal {
    private EntityHummingbird bird;
    private int idleAtFlowerTime = 0;
    private boolean isAboveDestinationBear;

    public HummingbirdAIPollinate(EntityHummingbird bird) {
        super((CreatureEntity)bird, 1.0, 32, 8);
        this.bird = bird;
    }

    public boolean func_75250_a() {
        return !this.bird.func_70631_g_() && this.bird.pollinateCooldown == 0 && super.func_75250_a();
    }

    public void func_75251_c() {
        this.idleAtFlowerTime = 0;
    }

    public double func_203110_f() {
        return 1.0;
    }

    public void func_75246_d() {
        super.func_75246_d();
        BlockPos blockpos = this.func_241846_j();
        if (!this.isWithinXZDist(blockpos, this.field_179495_c.func_213303_ch(), this.func_203110_f())) {
            this.isAboveDestinationBear = false;
            ++this.field_179493_e;
            double speedLoc = this.field_179492_d;
            if (this.field_179495_c.func_70092_e((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5) >= 3.0) {
                speedLoc = this.field_179492_d * 0.3;
            }
            this.field_179495_c.func_70605_aq().func_75642_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, speedLoc);
        } else {
            this.isAboveDestinationBear = true;
            --this.field_179493_e;
        }
        if (this.func_179487_f() && Math.abs(this.bird.func_226278_cu_() - (double)this.field_179494_b.func_177956_o()) <= 2.0) {
            this.bird.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177952_p() + 0.5));
            if (this.idleAtFlowerTime >= 20) {
                this.pollinate();
                this.func_75251_c();
            } else {
                ++this.idleAtFlowerTime;
            }
        }
    }

    private boolean isGrowable(BlockPos pos, ServerWorld world) {
        BlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        return block instanceof CropsBlock && !((CropsBlock)block).func_185525_y(blockstate);
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vector3d positionVec, double distance) {
        return blockpos.func_218140_a(positionVec.func_82615_a(), positionVec.func_82617_b(), positionVec.func_82616_c(), true) < distance * distance;
    }

    protected boolean func_179487_f() {
        return this.isAboveDestinationBear;
    }

    private void pollinate() {
        this.bird.field_70170_p.func_217379_c(2005, this.field_179494_b, 0);
        this.bird.setCropsPollinated(this.bird.getCropsPollinated() + 1);
        this.bird.pollinateCooldown = 200;
        if (this.bird.getCropsPollinated() > 3) {
            if (this.isGrowable(this.field_179494_b, (ServerWorld)this.bird.field_70170_p)) {
                BoneMealItem.func_195966_a((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)this.bird.field_70170_p, (BlockPos)this.field_179494_b);
            }
            this.bird.setCropsPollinated(0);
        }
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_226153_ac_) || worldIn.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_226149_I_)) {
            return this.bird.pollinateCooldown == 0;
        }
        return false;
    }
}

