/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class SnowLeopardAIMelee
extends Goal {
    private EntitySnowLeopard leopard;
    private LivingEntity target;
    private boolean secondPartOfLeap = false;
    private Vector3d leapPos = null;
    private boolean stalk = false;

    public SnowLeopardAIMelee(EntitySnowLeopard snowLeopard) {
        this.leopard = snowLeopard;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Nullable
    private static BlockPos func_226343_a_(Random p_226343_0_, int p_226343_1_, int p_226343_2_, int p_226343_3_, @Nullable Vector3d p_226343_4_, double p_226343_5_) {
        if (p_226343_4_ != null && p_226343_5_ < Math.PI) {
            double lvt_7_2_ = MathHelper.func_181159_b((double)p_226343_4_.field_72449_c, (double)p_226343_4_.field_72450_a) - 1.5707963705062866;
            double lvt_9_2_ = lvt_7_2_ + (double)(2.0f * p_226343_0_.nextFloat() - 1.0f) * p_226343_5_;
            double lvt_11_1_ = Math.sqrt(p_226343_0_.nextDouble()) * (double)MathHelper.field_180189_a * (double)p_226343_1_;
            double lvt_13_1_ = -lvt_11_1_ * Math.sin(lvt_9_2_);
            double lvt_15_1_ = lvt_11_1_ * Math.cos(lvt_9_2_);
            if (Math.abs(lvt_13_1_) <= (double)p_226343_1_ && Math.abs(lvt_15_1_) <= (double)p_226343_1_) {
                int lvt_17_1_ = p_226343_0_.nextInt(2 * p_226343_2_ + 1) - p_226343_2_ + p_226343_3_;
                return new BlockPos(lvt_13_1_, (double)lvt_17_1_, lvt_15_1_);
            }
            return null;
        }
        int lvt_7_1_ = p_226343_0_.nextInt(2 * p_226343_1_ + 1) - p_226343_1_;
        int lvt_8_1_ = p_226343_0_.nextInt(2 * p_226343_2_ + 1) - p_226343_2_ + p_226343_3_;
        int lvt_9_1_ = p_226343_0_.nextInt(2 * p_226343_1_ + 1) - p_226343_1_;
        return new BlockPos(lvt_7_1_, lvt_8_1_, lvt_9_1_);
    }

    static BlockPos func_226342_a_(BlockPos p_226342_0_, int p_226342_1_, int p_226342_2_, Predicate<BlockPos> p_226342_3_) {
        BlockPos lvt_6_1_;
        if (p_226342_1_ < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + p_226342_1_ + ", expected >= 0");
        }
        if (!p_226342_3_.test(p_226342_0_)) {
            return p_226342_0_;
        }
        BlockPos lvt_4_1_ = p_226342_0_.func_177984_a();
        while (lvt_4_1_.func_177956_o() < p_226342_2_ && p_226342_3_.test(lvt_4_1_)) {
            lvt_4_1_ = lvt_4_1_.func_177984_a();
        }
        BlockPos lvt_5_1_ = lvt_4_1_;
        while (lvt_5_1_.func_177956_o() < p_226342_2_ && lvt_5_1_.func_177956_o() - lvt_4_1_.func_177956_o() < p_226342_1_ && !p_226342_3_.test(lvt_6_1_ = lvt_5_1_.func_177984_a())) {
            lvt_5_1_ = lvt_6_1_;
        }
        return lvt_5_1_;
    }

    public boolean func_75250_a() {
        return this.leopard.func_70638_az() != null && (this.leopard.func_70638_az().func_70089_S() || this.leopard.func_70638_az() instanceof PlayerEntity) && !this.leopard.func_70631_g_();
    }

    public void func_75249_e() {
        this.target = this.leopard.func_70638_az();
        this.stalk = this.target instanceof PlayerEntity && this.leopard.func_70643_av() != null && this.leopard.func_70643_av() == this.target ? this.leopard.func_70032_d((Entity)this.target) > 10.0f : this.leopard.func_70032_d((Entity)this.target) > 4.0f;
        this.secondPartOfLeap = false;
    }

    public void func_75251_c() {
        this.secondPartOfLeap = false;
        this.stalk = false;
        this.leapPos = null;
        this.leopard.setTackling(false);
        this.leopard.setSlSneaking(false);
    }

    public void func_75246_d() {
        if (this.stalk) {
            if (this.secondPartOfLeap) {
                this.leopard.func_70625_a((Entity)this.target, 180.0f, 10.0f);
                this.leopard.field_70761_aq = this.leopard.field_70177_z;
                if (this.leopard.func_233570_aj_()) {
                    this.leopard.setSlSneaking(false);
                    this.leopard.setTackling(true);
                    Vector3d vector3d = this.leopard.func_213322_ci();
                    Vector3d vector3d1 = new Vector3d(this.target.func_226277_ct_() - this.leopard.func_226277_ct_(), 0.0, this.target.func_226281_cx_() - this.leopard.func_226281_cx_());
                    if (vector3d1.func_189985_c() > 1.0E-7) {
                        vector3d1 = vector3d1.func_72432_b().func_186678_a(0.9).func_178787_e(vector3d.func_186678_a(0.8));
                    }
                    this.leopard.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b + (double)0.6f, vector3d1.field_72449_c);
                }
                if (this.leopard.func_70032_d((Entity)this.target) < 3.0f && this.leopard.func_70685_l((Entity)this.target)) {
                    this.target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.leopard), (float)(this.leopard.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 2.5));
                    this.stalk = false;
                    this.secondPartOfLeap = false;
                }
            } else if (this.leapPos == null || this.target.func_195048_a(this.leapPos) > 250.0) {
                Vector3d vector3d1 = this.calculateFarPoint(50.0);
                if (vector3d1 != null) {
                    this.leapPos = vector3d1;
                }
            } else {
                this.leopard.setSlSneaking(true);
                this.leopard.func_70661_as().func_75492_a(this.leapPos.field_72450_a, this.leapPos.field_72448_b, this.leapPos.field_72449_c, 1.0);
                if (this.leopard.func_70092_e(this.leapPos.field_72450_a, this.leapPos.field_72448_b, this.leapPos.field_72449_c) < 9.0 && this.leopard.func_70685_l((Entity)this.target)) {
                    this.secondPartOfLeap = true;
                    this.leopard.func_70661_as().func_75499_g();
                }
            }
        } else {
            this.leopard.setSlSneaking(false);
            this.leopard.func_70661_as().func_75497_a((Entity)this.target, 1.0);
            if (this.leopard.func_70032_d((Entity)this.target) < 3.0f) {
                if (this.leopard.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    this.leopard.setAnimation(this.leopard.func_70681_au().nextBoolean() ? EntitySnowLeopard.ANIMATION_ATTACK_R : EntitySnowLeopard.ANIMATION_ATTACK_L);
                } else if (this.leopard.getAnimationTick() == 5) {
                    this.leopard.func_70652_k((Entity)this.target);
                }
            }
        }
    }

    private Vector3d calculateFarPoint(double dist) {
        Vector3d highest = null;
        for (int i = 0; i < 10; ++i) {
            Vector3d vector3d1 = this.calculateVantagePoint(this.target, 8, 3, 1, this.target.func_213303_ch().func_178786_a(this.leopard.func_226277_ct_(), this.leopard.func_226278_cu_(), this.leopard.func_226281_cx_()), false, 1.5707963705062866, arg_0 -> ((EntitySnowLeopard)this.leopard).func_180484_a(arg_0), false, 0, 0, true);
            if (vector3d1 == null || !(this.target.func_195048_a(vector3d1) > dist) || highest != null && !(highest.func_82617_b() < vector3d1.field_72448_b)) continue;
            highest = vector3d1;
        }
        return highest;
    }

    @Nullable
    private Vector3d calculateVantagePoint(LivingEntity creature, int xz, int y, int p_226339_3_, @Nullable Vector3d p_226339_4_, boolean p_226339_5_, double p_226339_6_, ToDoubleFunction<BlockPos> p_226339_8_, boolean p_226339_9_, int p_226339_10_, int p_226339_11_, boolean p_226339_12_) {
        PathNavigator lvt_13_1_ = this.leopard.func_70661_as();
        Random lvt_14_1_ = creature.func_70681_au();
        boolean lvt_15_2_ = this.leopard.func_213394_dL() ? this.leopard.func_213384_dI().func_218137_a((IPosition)creature.func_213303_ch(), (double)(this.leopard.func_213391_dJ() + (float)xz) + 1.0) : false;
        boolean lvt_16_1_ = false;
        double lvt_17_1_ = Double.NEGATIVE_INFINITY;
        BlockPos lvt_19_1_ = creature.func_233580_cy_();
        for (int lvt_20_1_ = 0; lvt_20_1_ < 10; ++lvt_20_1_) {
            double lvt_27_1_;
            PathNodeType lvt_26_1_;
            BlockPos lvt_25_2_;
            BlockPos lvt_21_1_ = SnowLeopardAIMelee.func_226343_a_(lvt_14_1_, xz, y, p_226339_3_, p_226339_4_, p_226339_6_);
            if (lvt_21_1_ == null) continue;
            int lvt_22_1_ = lvt_21_1_.func_177958_n();
            int lvt_23_1_ = lvt_21_1_.func_177956_o();
            int lvt_24_1_ = lvt_21_1_.func_177952_p();
            if (this.leopard.func_213394_dL() && xz > 1) {
                lvt_25_2_ = this.leopard.func_213384_dI();
                lvt_22_1_ = creature.func_226277_ct_() > (double)lvt_25_2_.func_177958_n() ? (lvt_22_1_ -= lvt_14_1_.nextInt(xz / 2)) : (lvt_22_1_ += lvt_14_1_.nextInt(xz / 2));
                lvt_24_1_ = creature.func_226281_cx_() > (double)lvt_25_2_.func_177952_p() ? (lvt_24_1_ -= lvt_14_1_.nextInt(xz / 2)) : (lvt_24_1_ += lvt_14_1_.nextInt(xz / 2));
            }
            if ((lvt_25_2_ = new BlockPos((double)lvt_22_1_ + creature.func_226277_ct_(), (double)lvt_23_1_ + creature.func_226278_cu_(), (double)lvt_24_1_ + creature.func_226281_cx_())).func_177956_o() < 0 || lvt_25_2_.func_177956_o() > creature.field_70170_p.func_217301_I() || lvt_15_2_ && !this.leopard.func_213389_a(lvt_25_2_) || p_226339_12_ && !lvt_13_1_.func_188555_b(lvt_25_2_)) continue;
            if (p_226339_9_) {
                lvt_25_2_ = SnowLeopardAIMelee.func_226342_a_(lvt_25_2_, lvt_14_1_.nextInt(p_226339_10_ + 1) + p_226339_11_, creature.field_70170_p.func_217301_I(), p_226341_1_ -> creature.field_70170_p.func_180495_p(p_226341_1_).func_185904_a().func_76220_a());
            }
            if (!p_226339_5_ && creature.field_70170_p.func_204610_c(lvt_25_2_).func_206884_a((ITag)FluidTags.field_206959_a) || this.leopard.func_184643_a(lvt_26_1_ = WalkNodeProcessor.func_237231_a_((IBlockReader)creature.field_70170_p, (BlockPos.Mutable)lvt_25_2_.func_239590_i_())) != 0.0f || !((lvt_27_1_ = p_226339_8_.applyAsDouble(lvt_25_2_)) > lvt_17_1_)) continue;
            lvt_17_1_ = lvt_27_1_;
            lvt_19_1_ = lvt_25_2_;
            lvt_16_1_ = true;
        }
        if (lvt_16_1_) {
            return Vector3d.func_237492_c_((Vector3i)lvt_19_1_);
        }
        return null;
    }
}

