/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.events;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;

public class EventBusHelper {
    private static final Map<Object, List<Subscription>> subscriptions = new HashMap<Object, List<Subscription>>();

    private static IEventBus getInstance() {
        return MinecraftForge.EVENT_BUS;
    }

    public static <T extends Event> void addListener(Object owner, Class<T> eventType, Consumer<T> listener) {
        EventBusHelper.addListener(owner, EventBusHelper.getInstance(), eventType, listener);
    }

    public static <T extends Event> void addListener(Object owner, IEventBus eventBus, Class<T> eventType, Consumer<T> listener) {
        subscriptions.computeIfAbsent(owner, e -> new ArrayList()).add(new Subscription(eventBus, listener));
        eventBus.addListener(EventPriority.NORMAL, false, eventType, listener);
    }

    public static <T extends ModLifecycleEvent> void addLifecycleListener(Object owner, IEventBus eventBus, Class<T> eventType, Consumer<T> listener) {
        EventBusHelper.addListener(owner, eventBus, eventType, listener);
    }

    public static <T extends Event> void removeListener(Object owner, Consumer<T> listener) {
        List<Subscription> subs = subscriptions.get(owner);
        if (subs != null) {
            subs.removeIf(sub -> {
                if (Objects.equals(((Subscription)sub).listener, listener)) {
                    ((Subscription)sub).unregister();
                    return true;
                }
                return false;
            });
        }
    }

    public static void register(Object owner) {
        IEventBus eventBus = EventBusHelper.getInstance();
        subscriptions.putIfAbsent(owner, new ArrayList());
        eventBus.register(owner);
    }

    public static void unregister(Object owner) {
        IEventBus eventBus = EventBusHelper.getInstance();
        List<Subscription> subs = subscriptions.remove(owner);
        if (subs != null) {
            for (Subscription sub : subs) {
                sub.unregister();
            }
        }
        eventBus.unregister(owner);
    }

    public static void post(Event event) {
        IEventBus eventBus = EventBusHelper.getInstance();
        eventBus.post(event);
    }

    public static <T, E extends Event> void registerWeakListener(T owner, Class<E> eventType, BiConsumer<T, E> handler) {
        WeakReference weakOwner = new WeakReference(owner);
        EventBusHelper.addListener(owner, eventType, event -> {
            Object nullableOwner = weakOwner.get();
            if (nullableOwner != null) {
                handler.accept(nullableOwner, event);
            }
        });
    }

    private static class Subscription {
        private final IEventBus eventBus;
        private final Consumer<? extends Event> listener;

        private <T extends Event> Subscription(IEventBus eventBus, Consumer<T> listener) {
            this.eventBus = eventBus;
            this.listener = listener;
        }

        private void unregister() {
            this.eventBus.unregister(this.listener);
        }
    }
}

