/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Raytracer {
    public static Set<BlockPos> rayTrace(Vector3d start, Vector3d end, World world) {
        return Raytracer.rayTrace(start, end, world, p -> {});
    }

    public static Set<BlockPos> rayTrace(Vector3d start, Vector3d end, World world, Consumer<BlockPos> out) {
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (start.func_216370_a(axis) > end.func_216370_a(axis)) {
                Vector3d tmp = start;
                start = end;
                end = tmp;
            }
            double min = start.func_216370_a(axis);
            double dif = end.func_216370_a(axis) - min;
            double lengthAdd = Math.ceil(min) - start.func_216370_a(axis);
            Vector3d mov = start.func_178788_d(end);
            if (mov.func_216370_a(axis) == 0.0) continue;
            mov = mov.func_186678_a(1.0 / mov.func_216370_a(axis));
            Raytracer.ray(dif, mov, start, lengthAdd, ret, world, checked, out);
        }
        if (checked.isEmpty()) {
            BlockPos pos = new BlockPos(start);
            BlockState state = world.func_180495_p(pos);
            BlockRayTraceResult rtr = state.func_196952_d((IBlockReader)world, pos).func_212433_a(start, end, pos);
            if (rtr != null && rtr.func_216346_c() != RayTraceResult.Type.MISS) {
                ret.add(pos);
            }
            checked.add(pos);
            out.accept(pos);
        }
        return ret;
    }

    private static void ray(double dif, Vector3d mov, Vector3d start, double lengthAdd, Set<BlockPos> ret, World world, Set<BlockPos> checked, Consumer<BlockPos> out) {
        double standardOff = 0.0625;
        int i = 0;
        while ((double)i < dif) {
            BlockRayTraceResult rtr;
            BlockState state;
            Vector3d pos = start.func_178787_e(mov.func_186678_a((double)i + lengthAdd + 0.0625));
            Vector3d posNext = start.func_178787_e(mov.func_186678_a((double)(i + 1) + lengthAdd + 0.0625));
            Vector3d posPrev = start.func_178787_e(mov.func_186678_a((double)i + lengthAdd - 0.0625));
            Vector3d posVeryPrev = start.func_178787_e(mov.func_186678_a((double)(i - 1) + lengthAdd - 0.0625));
            BlockPos blockPos = new BlockPos(pos);
            if (!checked.contains(blockPos) && (double)i + lengthAdd + 0.0625 < dif) {
                state = world.func_180495_p(blockPos);
                rtr = state.func_196952_d((IBlockReader)world, blockPos).func_212433_a(pos, posNext, blockPos);
                if (rtr != null && rtr.func_216346_c() != RayTraceResult.Type.MISS) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
                out.accept(blockPos);
            }
            if (!checked.contains(blockPos = new BlockPos(posPrev)) && (double)i + lengthAdd - 0.0625 < dif) {
                state = world.func_180495_p(blockPos);
                rtr = state.func_196952_d((IBlockReader)world, blockPos).func_212433_a(posVeryPrev, posPrev, blockPos);
                if (rtr != null && rtr.func_216346_c() != RayTraceResult.Type.MISS) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
                out.accept(blockPos);
            }
            ++i;
        }
    }
}

