/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.DynamicBucketModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public final class PotionBucketModel
implements IModelGeometry<PotionBucketModel> {
    private final QuadTransformer recolorTransformer;
    private final IModelGeometry<?> baseGeometry = new DynamicBucketModel(IEContent.fluidPotion, false, true, true, true);

    public PotionBucketModel(int color) {
        this.recolorTransformer = new QuadTransformer(new TransformationMatrix(null), $ -> color);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        IBakedModel baseModel = this.baseGeometry.bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation);
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(owner.getCombinedTransform(), modelTransform));
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)baseModel.getParticleTexture((IModelData)EmptyModelData.INSTANCE), (ItemOverrideList)new OverrideHandler(overrides, bakery, owner), (ImmutableMap)transformMap);
        ResourceLocation fluidMaskLocation = IEContent.fluidPotion.getAttributes().getStillTexture();
        for (Pair layer : baseModel.getLayerModels(ItemStack.field_190927_a, false)) {
            List baseQuads = ((IBakedModel)layer.getFirst()).getQuads(null, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(baseQuads.size());
            for (BakedQuad baseQuad : baseQuads) {
                if (baseQuad.func_187508_a().func_195668_m().equals((Object)fluidMaskLocation)) {
                    newQuads.add(this.recolorTransformer.apply(baseQuad));
                    continue;
                }
                newQuads.add(baseQuad);
            }
            builder.addQuads((RenderType)layer.getSecond(), newQuads);
        }
        return builder.build();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.baseGeometry.getTextures(owner, modelGetter, missingTextureErrors);
    }

    private static class OverrideHandler
    extends ItemOverrideList {
        private final Int2ObjectMap<IBakedModel> coloredModels = new Int2ObjectOpenHashMap();
        private final ItemOverrideList nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;

        private OverrideHandler(ItemOverrideList nested, ModelBakery bakery, IModelConfiguration owner) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
        }

        @Nullable
        public IBakedModel func_239290_a_(@Nonnull IBakedModel model, @Nonnull ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (fluid.isEmpty()) {
                return this.nested.func_239290_a_(model, stack, world, livingEntity);
            }
            int color = fluid.getFluid().getAttributes().getColor(fluid);
            return (IBakedModel)this.coloredModels.computeIfAbsent(color, i -> new PotionBucketModel(i).bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, this, ImmersiveEngineering.rl("potion_bucket_override")));
        }
    }

    public static class Loader
    implements IModelLoader<PotionBucketModel> {
        public static final ResourceLocation LOADER_NAME = ImmersiveEngineering.rl("potion_bucket");

        public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        }

        @Nonnull
        public PotionBucketModel read(@Nonnull JsonDeserializationContext deserializationContext, @Nonnull JsonObject modelContents) {
            return new PotionBucketModel(-1);
        }
    }
}

