/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.client.models.UnbakedModelGeometry;
import blusunrize.immersiveengineering.client.models.split.UnbakedSplitModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public class SplitModelLoader
implements IModelLoader<UnbakedSplitModel> {
    public static final ResourceLocation LOCATION = new ResourceLocation("immersiveengineering", "basic_split");
    public static final String PARTS = "split_parts";
    public static final String BASE_MODEL = "base_model";
    public static final String BASE_LOADER = "base_loader";
    public static final String DYNAMIC = "dynamic";

    public void func_195410_a(@Nonnull IResourceManager resourceManager) {
    }

    @Nonnull
    public UnbakedSplitModel read(@Nonnull JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        UnbakedModelGeometry baseModel;
        if (modelContents.has(BASE_MODEL)) {
            baseModel = new UnbakedModelGeometry((IUnbakedModel)ModelLoader.defaultModelGetter().apply(new ResourceLocation(modelContents.get(BASE_MODEL).getAsString())));
        } else {
            ResourceLocation subloader = modelContents.has(BASE_LOADER) ? new ResourceLocation(modelContents.get(BASE_LOADER).getAsString()) : new ResourceLocation("minecraft", "elements");
            baseModel = ModelLoaderRegistry.getModel((ResourceLocation)subloader, (JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
        }
        JsonArray partsJson = modelContents.getAsJsonArray(PARTS);
        ArrayList<Vector3i> parts = new ArrayList<Vector3i>(partsJson.size());
        for (Object e : partsJson) {
            parts.add(this.fromJson(e.getAsJsonArray()));
        }
        MutableBoundingBox box = this.pointBB((Vector3i)parts.get(0));
        for (Vector3i v : parts) {
            box.func_78888_b(this.pointBB(v));
        }
        Vector3i size = new Vector3i(box.func_78883_b(), box.func_78882_c(), box.func_78880_d());
        return new UnbakedSplitModel(baseModel, parts, modelContents.get(DYNAMIC).getAsBoolean(), size);
    }

    private Vector3i fromJson(JsonArray a) {
        return new Vector3i(a.get(0).getAsInt(), a.get(1).getAsInt(), a.get(2).getAsInt());
    }

    private MutableBoundingBox pointBB(Vector3i point) {
        return new MutableBoundingBox(point, point);
    }
}

