/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.IETileProviderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorTileEntity;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class ConnectorBlock
extends IETileProviderBlock {
    public ConnectorBlock(String name, BiFunction<Block, Item.Properties, Item> item) {
        this(name, item, (AbstractBlock.Properties $) -> {});
    }

    public ConnectorBlock(String name, BiFunction<Block, Item.Properties, Item> item, Consumer<AbstractBlock.Properties> extraSetup) {
        super(name, (AbstractBlock.Properties)Util.func_200696_a((Object)AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 15.0f).func_226896_b_(), extraSetup), item);
        this.lightOpacity = 0;
        this.setMobility(PushReaction.BLOCK);
    }

    public ConnectorBlock(String name) {
        this(name, BlockItemIE::new);
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        EnergyConnectorTileEntity connector;
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EnergyConnectorTileEntity && world.func_175623_d(pos.func_177972_a((connector = (EnergyConnectorTileEntity)te).getFacing()))) {
            ConnectorBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
            connector.getWorldNonnull().func_217377_a(pos, false);
        }
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult targetIn, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (player != null && player.func_225608_bj_() && world instanceof World && targetIn instanceof BlockRayTraceResult) {
            BlockRayTraceResult target = (BlockRayTraceResult)targetIn;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IImmersiveConnectable) {
                ConnectionPoint cp;
                TargetingInfo subTarget = new TargetingInfo(target.func_216354_b(), (float)target.func_216347_e().field_72450_a - (float)pos.func_177958_n(), (float)target.func_216347_e().field_72448_b - (float)pos.func_177956_o(), (float)target.func_216347_e().field_72449_c - (float)pos.func_177952_p());
                BlockPos masterPos = ((IImmersiveConnectable)te).getConnectionMaster(null, subTarget);
                if (masterPos != pos) {
                    te = world.func_175625_s(masterPos);
                }
                if (te instanceof IImmersiveConnectable && (cp = ((IImmersiveConnectable)te).getTargetedPoint(subTarget, (Vector3i)masterPos.func_177973_b((Vector3i)pos))) != null) {
                    for (Connection c : GlobalWireNetwork.getNetwork((World)world).getLocalNet(cp).getConnections(cp)) {
                        if (c.isInternal()) continue;
                        return c.type.getWireCoil(c);
                    }
                }
            }
        }
        return super.getPickBlock(state, targetIn, world, pos, player);
    }

    @Override
    public boolean allowHammerHarvest(BlockState state) {
        return true;
    }
}

