/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.common.config.CachedConfig;
import blusunrize.immersiveengineering.common.config.IECommonConfig;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.CuriosCompatModule;
import blusunrize.immersiveengineering.common.util.compat.OneProbeCompatModule;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.ComputerCraftCompatModule;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerCompatModule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

public abstract class IECompatModule {
    public static HashMap<String, Class<? extends IECompatModule>> moduleClasses = new HashMap();
    public static Set<IECompatModule> modules = new HashSet<IECompatModule>();
    public static boolean serverStartingDone;

    public static void doModulesPreInit() {
        for (Map.Entry<String, Class<? extends IECompatModule>> e : moduleClasses.entrySet()) {
            if (!ModList.get().isLoaded(e.getKey())) continue;
            try {
                CachedConfig.BooleanValue enabled;
                if ("ic2".equals(e.getKey()) && ModList.get().isLoaded("ic2-classic-spmod") || (enabled = IECommonConfig.compat.get(e.getKey())) == null || !((Boolean)enabled.get()).booleanValue()) continue;
                IECompatModule m = e.getValue().newInstance();
                modules.add(m);
                m.preInit();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + e.getKey() + " could not be preInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesInit() {
        for (IECompatModule compat : modules) {
            try {
                compat.init();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesPostInit() {
        for (IECompatModule compat : modules) {
            try {
                compat.postInit();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not be postInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesIMCs() {
        for (IECompatModule compat : modules) {
            try {
                compat.sendIMCs();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not send IMCs. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesLoadComplete() {
        if (!serverStartingDone) {
            serverStartingDone = true;
            for (IECompatModule compat : modules) {
                try {
                    compat.loadComplete();
                }
                catch (Exception exception) {
                    IELogger.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
                }
            }
        }
    }

    public abstract void preInit();

    public abstract void init();

    public abstract void postInit();

    public void sendIMCs() {
    }

    public void loadComplete() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientPreInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientPostInit() {
    }

    static {
        moduleClasses.put("computercraft", ComputerCraftCompatModule.class);
        moduleClasses.put("crafttweaker", CraftTweakerCompatModule.class);
        moduleClasses.put("theoneprobe", OneProbeCompatModule.class);
        moduleClasses.put("curios", CuriosCompatModule.class);
        serverStartingDone = false;
    }
}

