/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.projector;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import flaxbeard.immersivepetroleum.common.network.MessageProjectorSync;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Settings {
    public static final String KEY_SELF = "settings";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_MODE = "mode";
    public static final String KEY_MULTIBLOCK = "multiblock";
    public static final String KEY_MIRROR = "mirror";
    public static final String KEY_PLACED = "placed";
    public static final String KEY_ROTATION = "rotation";
    public static final String KEY_POSITION = "pos";
    private Mode mode;
    private Rotation rotation;
    private BlockPos pos = null;
    private MultiblockHandler.IMultiblock multiblock = null;
    private boolean mirror;
    private boolean isPlaced;

    public Settings() {
        this(new CompoundNBT());
    }

    public Settings(@Nullable ItemStack stack) {
        this(((Supplier<CompoundNBT>)() -> {
            CompoundNBT nbt = null;
            if (stack != null && (nbt = stack.func_179543_a(KEY_SELF)) == null) {
                nbt = new CompoundNBT();
            }
            return nbt;
        }).get());
    }

    public Settings(CompoundNBT settingsNbt) {
        if (settingsNbt == null || settingsNbt.isEmpty()) {
            this.mode = Mode.MULTIBLOCK_SELECTION;
            this.rotation = Rotation.NONE;
            this.mirror = false;
            this.isPlaced = false;
        } else {
            this.mode = Mode.values()[MathHelper.func_76125_a((int)settingsNbt.func_74762_e(KEY_MODE), (int)0, (int)(Mode.values().length - 1))];
            this.rotation = Rotation.values()[settingsNbt.func_74764_b(KEY_ROTATION) ? settingsNbt.func_74762_e(KEY_ROTATION) : 0];
            this.mirror = settingsNbt.func_74767_n(KEY_MIRROR);
            this.isPlaced = settingsNbt.func_74767_n(KEY_PLACED);
            if (settingsNbt.func_150297_b(KEY_MULTIBLOCK, 8)) {
                String str = settingsNbt.func_74779_i(KEY_MULTIBLOCK);
                this.multiblock = MultiblockHandler.getByUniqueName((ResourceLocation)new ResourceLocation(str));
            }
            if (settingsNbt.func_150297_b(KEY_POSITION, 10)) {
                CompoundNBT pos = settingsNbt.func_74775_l(KEY_POSITION);
                int x = pos.func_74762_e("x");
                int y = pos.func_74762_e("y");
                int z = pos.func_74762_e("z");
                this.pos = new BlockPos(x, y, z);
            }
        }
    }

    public void rotateCW() {
        this.rotation = this.rotation.func_185830_a(Rotation.CLOCKWISE_90);
    }

    public void rotateCCW() {
        this.rotation = this.rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
    }

    public void flip() {
        this.mirror = !this.mirror;
    }

    public void switchMode() {
        int id = this.mode.ordinal() + 1;
        this.mode = Mode.values()[id % Mode.values().length];
    }

    public void sendPacketToServer(Hand hand) {
        MessageProjectorSync.sendToServer(this, hand);
    }

    public void sendPacketToClient(PlayerEntity player, Hand hand) {
        MessageProjectorSync.sendToClient(player, this, hand);
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setMultiblock(@Nullable MultiblockHandler.IMultiblock multiblock) {
        this.multiblock = multiblock;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public void setPlaced(boolean isPlaced) {
        this.isPlaced = isPlaced;
    }

    public void setPos(@Nullable BlockPos pos) {
        this.pos = pos;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public boolean isPlaced() {
        return this.isPlaced;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(KEY_MODE, this.mode.ordinal());
        nbt.func_74768_a(KEY_ROTATION, this.rotation.ordinal());
        nbt.func_74757_a(KEY_MIRROR, this.mirror);
        nbt.func_74757_a(KEY_PLACED, this.isPlaced);
        if (this.multiblock != null) {
            nbt.func_74778_a(KEY_MULTIBLOCK, this.multiblock.getUniqueName().toString());
        }
        if (this.pos != null) {
            CompoundNBT pos = new CompoundNBT();
            pos.func_74768_a("x", this.pos.func_177958_n());
            pos.func_74768_a("y", this.pos.func_177956_o());
            pos.func_74768_a("z", this.pos.func_177952_p());
            nbt.func_218657_a(KEY_POSITION, (INBT)pos);
        }
        return nbt;
    }

    public ItemStack applyTo(ItemStack stack) {
        stack.func_190925_c(KEY_SELF);
        stack.func_77978_p().func_218657_a(KEY_SELF, (INBT)this.toNbt());
        return stack;
    }

    public String toString() {
        return "\"Settings\":[" + this.toNbt().toString() + "]";
    }

    public static enum Mode {
        MULTIBLOCK_SELECTION,
        PROJECTION;

        final String translation = "desc.immersivepetroleum.info.projector.mode_" + this.ordinal();

        public ITextComponent getTranslated() {
            return new TranslationTextComponent(this.translation);
        }
    }
}

