/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.google.common.base.MoreObjects;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface ItemSearchMode {
    public static final ItemSearchMode ALL_ITEMS = new ItemSearchMode(){
        private List<ItemStack> allItemsCache = null;

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.field_151111_aL);
        }

        @Override
        public IFormattableTextComponent getDisplayName() {
            return new TranslationTextComponent("ftblibrary.select_item.list_mode.all");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            if (this.allItemsCache == null) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Registry.field_212630_s.func_148742_b().size() + 100);
                for (Item item : Registry.field_212630_s) {
                    NonNullList list = NonNullList.func_191196_a();
                    ItemGroup category = item.func_77640_w();
                    item.func_150895_a((ItemGroup)MoreObjects.firstNonNull((Object)category, (Object)ItemGroup.field_78027_g), list);
                    if (list.isEmpty()) {
                        stacks.add(item.func_190903_i());
                        continue;
                    }
                    stacks.addAll((Collection<ItemStack>)list);
                }
                this.allItemsCache = stacks;
            }
            return this.allItemsCache;
        }
    };
    public static final ItemSearchMode INVENTORY = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.field_221675_bZ);
        }

        @Override
        public IFormattableTextComponent getDisplayName() {
            return new TranslationTextComponent("ftblibrary.select_item.list_mode.inv");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return Collections.emptySet();
            }
            int inv = player.field_71071_by.func_70302_i_();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(inv);
            for (int i = 0; i < inv; ++i) {
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                items.add(stack);
            }
            return items;
        }
    };

    public Icon getIcon();

    public IFormattableTextComponent getDisplayName();

    public Collection<ItemStack> getAllItems();
}

