/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.FTBLibraryClient;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageCallback;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class IconRenderer<T> {
    private static IconRenderer<PixelBuffer> defaultIconRenderer;
    private final Function<PixelBuffer, T> factory;
    private final Collection<IconCallbackPair<T>> queue;
    private T nullImage;
    private Map<Icon, T> imageCache;

    public static <E> IconRenderer<E> create(Function<PixelBuffer, E> factory) {
        IconRenderer<E> iconRenderer = new IconRenderer<E>(factory);
        FTBLibraryClient.ICON_RENDERERS.add(iconRenderer);
        return iconRenderer;
    }

    public static IconRenderer<PixelBuffer> createDefault() {
        if (defaultIconRenderer == null) {
            defaultIconRenderer = IconRenderer.create(pixelBuffer -> pixelBuffer);
        }
        return defaultIconRenderer;
    }

    private IconRenderer(Function<PixelBuffer, T> f) {
        this.factory = f;
        this.queue = new LinkedList<IconCallbackPair<T>>();
        this.nullImage = null;
        this.imageCache = new HashMap<Icon, T>();
    }

    public void clearCache() {
        this.imageCache = new HashMap<Icon, T>();
    }

    public T getNullImage() {
        if (this.nullImage == null) {
            ResourceLocation rl = Platform.isModLoaded((String)"ftbquests") ? new ResourceLocation("ftbquests:textures/item/missing_item.png") : new ResourceLocation("ftblibrary", "textures/icons/cancel.png");
            try (InputStream stream = Minecraft.func_71410_x().func_195551_G().func_199002_a(rl).func_199027_b();){
                this.nullImage = this.factory.apply(PixelBuffer.from(stream));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.nullImage;
    }

    public boolean load(@Nullable Icon icon, ImageCallback<T> callback) {
        if (icon == null) {
            callback.imageLoaded(false, null);
            return true;
        }
        if (icon.isEmpty()) {
            callback.imageLoaded(false, this.getNullImage());
            return true;
        }
        T image = this.imageCache.get(icon);
        if (image != null) {
            callback.imageLoaded(false, image);
            return true;
        }
        if (icon.hasPixelBuffer()) {
            PixelBuffer buffer = icon.createPixelBuffer();
            image = buffer == null ? this.getNullImage() : this.factory.apply(buffer);
            this.imageCache.put(icon, image);
            callback.imageLoaded(false, image);
            return true;
        }
        this.imageCache.put(icon, this.getNullImage());
        callback.imageLoaded(false, this.getNullImage());
        IconCallbackPair pair = new IconCallbackPair();
        pair.iconRenderer = this;
        pair.icon = icon;
        pair.callback = callback;
        Minecraft.func_71410_x().execute(pair);
        return false;
    }

    public void render() {
        if (this.queue.isEmpty()) {
            return;
        }
        Object[] queued = this.queue.toArray();
        this.queue.clear();
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow res = mc.func_228018_at_();
        int size = Math.min(Math.min(res.func_198109_k(), res.func_198091_l()), 64);
        MatrixStack matrixStack = new MatrixStack();
        RenderSystem.pushMatrix();
        RenderSystem.enableLighting();
        double scale = (double)size / (16.0 * res.func_198100_s());
        RenderSystem.translated((double)0.0, (double)0.0, (double)(-(scale * 100.0)));
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        float oldZLevel = mc.func_175599_af().field_77023_b;
        mc.func_175599_af().field_77023_b = -50.0f;
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)770, (int)1);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableAlphaTest();
        PixelBuffer buffer = new PixelBuffer(size, size);
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -size));
        BufferedImage img = new BufferedImage(size, size, 2);
        for (Object pair0 : queued) {
            IconCallbackPair pair = (IconCallbackPair)pair0;
            RenderSystem.pushMatrix();
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16640, (boolean)false);
            pair.icon.drawStatic(matrixStack, 0, 0, 16, 16);
            RenderSystem.popMatrix();
            try {
                ByteBuffer buf = BufferUtils.createByteBuffer((int)(size * size * 4));
                GL11.glReadBuffer((int)1029);
                GL11.glGetError();
                GL11.glReadPixels((int)0, (int)(res.func_198091_l() - size), (int)size, (int)size, (int)32993, (int)5121, (ByteBuffer)buf);
                buf.asIntBuffer().get(buffer.getPixels());
                img.setRGB(0, 0, size, size, buffer.getPixels(), 0, size);
                BufferedImage flipped = new BufferedImage(size, size, 2);
                Graphics2D g = flipped.createGraphics();
                g.transform(at);
                g.drawImage((Image)img, 0, 0, null);
                g.dispose();
                flipped.getRGB(0, 0, size, size, buffer.getPixels(), 0, size);
                T image = this.factory.apply(buffer);
                this.imageCache.put(pair.icon, image);
                pair.callback.imageLoaded(true, image);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        RenderSystem.disableLighting();
        RenderSystem.disableColorMaterial();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        mc.func_175599_af().field_77023_b = oldZLevel;
    }

    private static class IconCallbackPair<E>
    implements Runnable {
        private IconRenderer<E> iconRenderer;
        private Icon icon;
        private ImageCallback<E> callback;

        private IconCallbackPair() {
        }

        @Override
        public void run() {
            ((IconRenderer)this.iconRenderer).queue.add(this);
        }
    }
}

