/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitstorage;

import java.util.List;
import mod.chiselsandbits.bitstorage.TileEntityBitStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemBlockBitStorage
extends BlockItem {
    public ItemBlockBitStorage(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null) {
            return;
        }
        FluidStack fluid = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (fluid.isEmpty()) {
            ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpBitTankEmpty, tooltip, new String[0]);
        } else {
            ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpBitTankFilled, tooltip, DeprecationHelper.translateToLocal(fluid.getTranslationKey()), String.valueOf((int)Math.floor((double)fluid.getAmount() * 4.096)));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack(stack, 1000);
    }

    protected boolean func_195943_a(BlockPos pos, World worldIn, @Nullable PlayerEntity player, ItemStack stack, BlockState state) {
        super.func_195943_a(pos, worldIn, player, stack, state);
        if (worldIn.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityBitStorage)) {
            return false;
        }
        TileEntityBitStorage tileEntityBitStorage = (TileEntityBitStorage)tileEntity;
        tileEntityBitStorage.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(t -> t.fill(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(s -> s.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY), IFluidHandler.FluidAction.EXECUTE));
        return true;
    }
}

