/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.recipe;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.recipes.RecipeIngredientJson;
import com.ldtteam.datagenerators.recipes.RecipeIngredientKeyJson;
import com.ldtteam.datagenerators.recipes.RecipeResultJson;
import com.ldtteam.datagenerators.recipes.shapeless.ShapelessRecipeJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;

public abstract class AbstractPrintRecipeGenerator<ITEM extends Item>
implements IDataProvider {
    private final DataGenerator generator;
    private final ITEM item;
    private final ITEM printedItem;
    private final ITag.INamedTag<Item> primaryIngredient;

    protected AbstractPrintRecipeGenerator(DataGenerator generator, ITEM item, ITEM printedItem, ITag.INamedTag<Item> primaryIngredient) {
        this.generator = generator;
        this.item = item;
        this.printedItem = printedItem;
        this.primaryIngredient = primaryIngredient;
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.generateInitialRecipe(cache);
        this.generateCleanResettingRecipe(cache);
        this.generatePrintedResettingRecipe(cache);
    }

    private void generateInitialRecipe(DirectoryCache cache) throws IOException {
        ShapelessRecipeJson shapelessRecipeJson = new ShapelessRecipeJson();
        shapelessRecipeJson.setGroup("chiselsandbits");
        shapelessRecipeJson.setRecipeType(ShapelessRecipeJson.getDefaultType());
        shapelessRecipeJson.setIngredients((List)Lists.newArrayList((Object[])new RecipeIngredientKeyJson[]{new RecipeIngredientKeyJson(new RecipeIngredientJson("forge:paper", true)), new RecipeIngredientKeyJson(new RecipeIngredientJson(Objects.requireNonNull(Items.field_151131_as.getRegistryName()).toString(), false)), new RecipeIngredientKeyJson(new RecipeIngredientJson(this.primaryIngredient.func_230234_a_().toString(), true))}));
        shapelessRecipeJson.setResult(new RecipeResultJson(1, Objects.requireNonNull(this.item.getRegistryName()).toString()));
        Path recipeFolder = this.generator.func_200391_b().resolve("data/chiselsandbits/recipes/");
        Path initialRecipeFolder = recipeFolder.resolve(this.item.getRegistryName().func_110623_a() + "_initial.json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)shapelessRecipeJson.serialize(), (Path)initialRecipeFolder);
    }

    private void generateCleanResettingRecipe(DirectoryCache cache) throws IOException {
        this.generateResettingRecipe(cache, this.item, "resetting");
    }

    private void generatePrintedResettingRecipe(DirectoryCache cache) throws IOException {
        this.generateResettingRecipe(cache, this.printedItem, "cleaning");
    }

    private void generateResettingRecipe(DirectoryCache cache, ITEM printedItem, String suffix) throws IOException {
        ShapelessRecipeJson shapelessRecipeJson = new ShapelessRecipeJson();
        shapelessRecipeJson.setGroup("chiselsandbits");
        shapelessRecipeJson.setRecipeType(ShapelessRecipeJson.getDefaultType());
        shapelessRecipeJson.setIngredients((List)Lists.newArrayList((Object[])new RecipeIngredientKeyJson[]{new RecipeIngredientKeyJson(new RecipeIngredientJson(Objects.requireNonNull(printedItem.getRegistryName()).toString(), false))}));
        shapelessRecipeJson.setResult(new RecipeResultJson(1, Objects.requireNonNull(this.item.getRegistryName()).toString()));
        Path recipeFolder = this.generator.func_200391_b().resolve("data/chiselsandbits/recipes/");
        Path initialRecipeFolder = recipeFolder.resolve(this.item.getRegistryName().func_110623_a() + "_" + suffix + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)shapelessRecipeJson.serialize(), (Path)initialRecipeFolder);
    }

    public String func_200397_b() {
        return Objects.requireNonNull(this.item.getRegistryName()).toString() + " recipe generator";
    }
}

