/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import mod.chiselsandbits.registry.ModRecipeSerializers;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpecialCraftingRecipeGenerator
implements IDataProvider {
    private final DataGenerator generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new SpecialCraftingRecipeGenerator(event.getGenerator()));
    }

    private SpecialCraftingRecipeGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.saveRecipe(cache, ModRecipeSerializers.BAG_DYEING.getId());
        this.saveRecipe(cache, ModRecipeSerializers.CHISEL_BLOCK_CRAFTING.getId());
        this.saveRecipe(cache, ModRecipeSerializers.BIT_SAW_CRAFTING.getId());
        this.saveRecipe(cache, ModRecipeSerializers.CHISEL_CRAFTING.getId());
        this.saveRecipe(cache, ModRecipeSerializers.MIRROR_TRANSFER_CRAFTING.getId());
        this.saveRecipe(cache, ModRecipeSerializers.NEGATIVE_INVERSION_CRAFTING.getId());
        this.saveRecipe(cache, ModRecipeSerializers.STACKABLE_CRAFTING.getId());
    }

    private void saveRecipe(DirectoryCache cache, ResourceLocation location) throws IOException {
        JsonObject object = new JsonObject();
        object.addProperty("type", location.toString());
        Path recipeFolder = this.generator.func_200391_b().resolve("data/chiselsandbits/recipes/");
        Path recipePath = recipeFolder.resolve(location.func_110623_a() + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)object, (Path)recipePath);
    }

    public String func_200397_b() {
        return "Special crafting recipe generator";
    }
}

