/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.helpers.IVoxelSrc;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class VoxelRegionSrc
implements IVoxelSrc {
    final BlockPos min;
    final BlockPos max;
    final BlockPos actingCenter;
    final int wrapZ;
    final int wrapY;
    final int wrapX;
    final VoxelBlob[] blobs;

    private VoxelRegionSrc(World src, BlockPos min, BlockPos max, BlockPos actingCenter) {
        this.min = min;
        this.max = max;
        this.actingCenter = actingCenter.func_177973_b((Vector3i)min);
        this.wrapX = max.func_177958_n() - min.func_177958_n() + 1;
        this.wrapY = max.func_177956_o() - min.func_177956_o() + 1;
        this.wrapZ = max.func_177952_p() - min.func_177952_p() + 1;
        this.blobs = new VoxelBlob[this.wrapX * this.wrapY * this.wrapZ];
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    int idx = x - min.func_177958_n() + (y - min.func_177956_o()) * this.wrapX + (z - min.func_177952_p()) * this.wrapX * this.wrapY;
                    try {
                        BitAccess access = (BitAccess)ChiselsAndBits.getApi().getBitAccess(src, new BlockPos(x, y, z));
                        this.blobs[idx] = access.getNativeBlob();
                        continue;
                    }
                    catch (APIExceptions.CannotBeChiseled e) {
                        this.blobs[idx] = new VoxelBlob();
                    }
                }
            }
        }
    }

    public VoxelRegionSrc(World theWorld, BlockPos blockPos, int range) {
        this(theWorld, blockPos.func_177982_a(-range, -range, -range), blockPos.func_177982_a(range, range, range), blockPos);
    }

    @Override
    public int getSafe(int x, int y, int z) {
        int bitPosX = (x += this.actingCenter.func_177958_n() * 16) & 0xF;
        int bitPosY = (y += this.actingCenter.func_177956_o() * 16) & 0xF;
        int bitPosZ = (z += this.actingCenter.func_177952_p() * 16) & 0xF;
        int blkPosX = x >> 4;
        int blkPosY = y >> 4;
        int blkPosZ = z >> 4;
        int idx = blkPosX + blkPosY * this.wrapX + blkPosZ * this.wrapX * this.wrapY;
        if (blkPosX < 0 || blkPosY < 0 || blkPosZ < 0 || blkPosX >= this.wrapX || blkPosY >= this.wrapY || blkPosZ >= this.wrapZ) {
            return 0;
        }
        return this.blobs[idx].get(bitPosX, bitPosY, bitPosZ);
    }

    public VoxelBlob getBlobAt(BlockPos blockPos) {
        int blkPosX = blockPos.func_177958_n() - this.min.func_177958_n();
        int blkPosY = blockPos.func_177956_o() - this.min.func_177956_o();
        int blkPosZ = blockPos.func_177952_p() - this.min.func_177952_p();
        int idx = blkPosX + blkPosY * this.wrapX + blkPosZ * this.wrapX * this.wrapY;
        if (blkPosX < 0 || blkPosY < 0 || blkPosZ < 0 || blkPosX >= this.wrapX || blkPosY >= this.wrapY || blkPosZ >= this.wrapZ) {
            return new VoxelBlob();
        }
        return this.blobs[idx];
    }
}

