/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.VoxelStats;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitInventoryFeeder;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.interfaces.IVoxelBlobItem;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemNegativePrint
extends Item
implements IVoxelBlobItem,
IItemScrollWheel,
IPatternItem {
    SimpleInstanceCache<ItemStack, List<ITextComponent>> toolTipCache = new SimpleInstanceCache(null, new ArrayList());

    public ItemNegativePrint(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void defaultAddInfo(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        this.defaultAddInfo(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().getCommon().helpText(LocalStrings.HelpNegativePrint, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G));
        if (this.isWritten(stack)) {
            if (ClientSide.instance.holdingShift()) {
                List<ITextComponent> details = this.toolTipCache.getCached();
                if (this.toolTipCache.needsUpdate(stack)) {
                    details.clear();
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    int solid = blob.filled();
                    int air = blob.air();
                    if (solid > 0) {
                        details.add((ITextComponent)new StringTextComponent(Integer.valueOf(solid).toString()).func_240702_b_(" ").func_230529_a_((ITextComponent)new StringTextComponent(LocalStrings.Filled.getLocal())));
                    }
                    if (air > 0) {
                        details.add((ITextComponent)new StringTextComponent(Integer.valueOf(air).toString()).func_240702_b_(" ").func_230529_a_((ITextComponent)new StringTextComponent(LocalStrings.Empty.getLocal())));
                    }
                }
                tooltip.addAll(details);
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(LocalStrings.ShiftDetails.getLocal()));
            }
        }
    }

    @Override
    public boolean isWritten(ItemStack stack) {
        if (stack.func_77973_b() != this.getWrittenItem()) {
            return false;
        }
        if (stack.func_77942_o()) {
            boolean a = ModUtil.getSubCompound(stack, "BlockEntityTag", false).func_186856_d() != 0;
            boolean b = ModUtil.getTagCompound(stack).func_74764_b("v");
            boolean c = ModUtil.getTagCompound(stack).func_74764_b("X");
            return a || b || c;
        }
        return false;
    }

    protected Item getWrittenItem() {
        return (Item)ModItems.ITEM_NEGATIVE_PRINT_WRITTEN.get();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        ItemStack stack = player.func_184586_b(hand);
        BlockState blkstate = world.func_180495_p(pos);
        if (ItemChiseledBit.checkRequiredSpace(player, blkstate)) {
            return ActionResultType.FAIL;
        }
        if (!player.func_175151_a(pos, side, stack) || !world.func_175660_a(player, pos)) {
            return ActionResultType.FAIL;
        }
        if (!this.isWritten(stack)) {
            CompoundNBT comp = this.getCompoundFromBlock(world, pos, player);
            if (comp != null) {
                int count = stack.func_190916_E();
                stack.func_190918_g(count);
                ItemStack newStack = new ItemStack(this::getWrittenItem, count);
                newStack.func_77982_d(comp);
                ItemEntity itementity = player.func_71019_a(newStack, false);
                if (itementity != null) {
                    itementity.func_174868_q();
                    itementity.func_200217_b(player.func_110124_au());
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, false);
        if (te == null && !BlockChiseled.replaceWithChiseled(world, pos, blkstate, true)) {
            return ActionResultType.FAIL;
        }
        TileEntityBlockChiseled tec = ModUtil.getChiseledTileEntity(world, pos, true);
        if (tec != null) {
            VoxelBlob vb = tec.getBlob();
            VoxelBlob pattern = ModUtil.getBlobFromStack(stack, (LivingEntity)player);
            this.applyPrint(stack, world, pos, side, vb, pattern, player, hand);
            tec.completeEditOperation(vb);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected boolean convertToStone() {
        return true;
    }

    protected CompoundNBT getCompoundFromBlock(World world, BlockPos pos, PlayerEntity player) {
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, false);
        if (te != null) {
            CompoundNBT comp = new CompoundNBT();
            te.writeChiselData(comp);
            if (this.convertToStone()) {
                TileEntityBlockChiseled tmp = new TileEntityBlockChiseled();
                tmp.readChiselData(comp);
                VoxelBlob bestBlob = tmp.getBlob();
                bestBlob.binaryReplacement(0, ModUtil.getStateId(Blocks.field_150348_b.func_176223_P()));
                tmp.setBlob(bestBlob);
                tmp.writeChiselData(comp);
            }
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((LivingEntity)player).ordinal());
            return comp;
        }
        return null;
    }

    @Override
    public ItemStack getPatternedItem(ItemStack stack, boolean craftingBlocks) {
        if (!this.isWritten(stack)) {
            return null;
        }
        CompoundNBT tag = ModUtil.getTagCompound(stack);
        NBTBlobConverter conv = new NBTBlobConverter();
        conv.readChisleData(tag, -1);
        if (craftingBlocks && ((Boolean)ChiselsAndBits.getConfig().getServer().fullBlockCrafting.get()).booleanValue()) {
            BlockState state;
            ItemStack is;
            VoxelStats stats = conv.getBlob().getVoxelStats();
            if (stats.isFullBlock && !ModUtil.isEmpty(is = ModUtil.getItemStackFromBlockState(state = ModUtil.getStateById(stats.mostCommonState)))) {
                return is;
            }
        }
        BlockState state = conv.getPrimaryBlockState();
        ItemStack itemstack = new ItemStack((IItemProvider)ModBlocks.convertGivenStateToChiseledBlock(state), 1);
        itemstack.func_77983_a("BlockEntityTag", (INBT)tag);
        return itemstack;
    }

    protected void applyPrint(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side, @Nonnull VoxelBlob vb, @Nonnull VoxelBlob pattern, @Nonnull PlayerEntity who, @Nonnull Hand hand) {
        ActingPlayer player = ActingPlayer.actingAs(who, hand);
        ContinousChisels selected = new ContinousChisels(player, pos, side);
        ItemStack spawnedItem = null;
        ArrayList<ItemEntity> spawnlist = new ArrayList<ItemEntity>();
        for (int z = 0; z < vb.detail && selected.isValid(); ++z) {
            for (int y = 0; y < vb.detail && selected.isValid(); ++y) {
                for (int x = 0; x < vb.detail && selected.isValid(); ++x) {
                    int blkID = vb.get(x, y, z);
                    if (blkID == 0 || pattern.get(x, y, z) != 0) continue;
                    spawnedItem = ItemChisel.chiselBlock(selected, player, vb, world, pos, side, x, y, z, spawnedItem, spawnlist);
                }
            }
        }
        BitInventoryFeeder feeder = new BitInventoryFeeder(who, world);
        for (ItemEntity ei : spawnlist) {
            feeder.addItem(ei);
        }
    }

    @Override
    public void scroll(PlayerEntity player, ItemStack stack, int dwheel) {
        PacketRotateVoxelBlob p = new PacketRotateVoxelBlob(Direction.Axis.Y, dwheel > 0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        ChiselsAndBits.getNetworkChannel().sendToServer(p);
    }

    @Override
    public void rotate(ItemStack stack, Direction.Axis axis, Rotation rotation) {
        Direction side = ModUtil.getSide(stack);
        if (axis == Direction.Axis.Y) {
            if (side.func_176740_k() == Direction.Axis.Y) {
                side = Direction.NORTH;
            }
            switch (rotation) {
                case CLOCKWISE_180: {
                    side = side.func_176746_e();
                }
                case CLOCKWISE_90: {
                    side = side.func_176746_e();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    side = side.func_176735_f();
                    break;
                }
            }
        } else {
            IBitAccess ba = ChiselsAndBits.getApi().createBitItem(stack);
            ba.rotate(axis, rotation);
            stack.func_77982_d(ba.getBitsAsItem(side, ChiselsAndBits.getApi().getItemType(stack), false).func_77978_p());
        }
        ModUtil.setSide(stack, side);
    }
}

