/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.network.ModPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class PacketAccurateSneakPlace
extends ModPacket {
    private ItemStack stack;
    private BlockPos pos;
    private Hand hand;
    private Direction side;
    private double hitX;
    private double hitY;
    private double hitZ;
    private boolean offgrid;

    public PacketAccurateSneakPlace(PacketBuffer buffer) {
        this.readPayload(buffer);
    }

    public PacketAccurateSneakPlace(ItemStack stack, BlockPos pos, Hand hand, Direction side, double hitX, double hitY, double hitZ, boolean offgrid) {
        this.stack = stack;
        this.pos = pos;
        this.hand = hand;
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
        this.offgrid = offgrid;
    }

    @Override
    public void server(ServerPlayerEntity playerEntity) {
        ItemStack inHand;
        if (this.stack != null && this.stack.func_77973_b() instanceof IItemBlockAccurate && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)(inHand = playerEntity.func_184586_b(this.hand)))) {
            if (playerEntity.func_184812_l_()) {
                inHand = this.stack;
            }
            IItemBlockAccurate ibc = (IItemBlockAccurate)this.stack.func_77973_b();
            ItemUseContext context = new ItemUseContext((PlayerEntity)playerEntity, this.hand, new BlockRayTraceResult(new Vector3d(this.hitX, this.hitY, this.hitZ), this.side, this.pos, false));
            ibc.tryPlace((ItemUseContext)new BlockItemUseContext(context), this.offgrid);
            if (!playerEntity.func_184812_l_() && ModUtil.getStackSize(inHand) <= 0) {
                playerEntity.func_184611_a(this.hand, ModUtil.getEmptyStack());
            }
        }
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        buffer.func_150788_a(this.stack);
        buffer.func_179255_a(this.pos);
        buffer.func_179249_a((Enum)this.side);
        buffer.func_179249_a((Enum)this.hand);
        buffer.writeDouble(this.hitX);
        buffer.writeDouble(this.hitY);
        buffer.writeDouble(this.hitZ);
        buffer.writeBoolean(this.offgrid);
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.stack = buffer.func_150791_c();
        this.pos = buffer.func_179259_c();
        this.side = (Direction)buffer.func_179257_a(Direction.class);
        this.hand = (Hand)buffer.func_179257_a(Hand.class);
        this.hitX = buffer.readDouble();
        this.hitY = buffer.readDouble();
        this.hitZ = buffer.readDouble();
        this.offgrid = buffer.readBoolean();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public Hand getHand() {
        return this.hand;
    }

    public void setHand(Hand hand) {
        this.hand = hand;
    }

    public Direction getSide() {
        return this.side;
    }

    public void setSide(Direction side) {
        this.side = side;
    }

    public double getHitX() {
        return this.hitX;
    }

    public void setHitX(double hitX) {
        this.hitX = hitX;
    }

    public double getHitY() {
        return this.hitY;
    }

    public void setHitY(double hitY) {
        this.hitY = hitY;
    }

    public double getHitZ() {
        return this.hitZ;
    }

    public void setHitZ(double hitZ) {
        this.hitZ = hitZ;
    }

    public boolean isOffgrid() {
        return this.offgrid;
    }

    public void setOffgrid(boolean offgrid) {
        this.offgrid = offgrid;
    }

    public static interface IItemBlockAccurate {
        public ActionResultType tryPlace(ItemUseContext var1, boolean var2);
    }
}

