/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import java.security.InvalidParameterException;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelType;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.culling.MCCullTest;
import net.minecraft.client.renderer.RenderType;

public enum ChiselRenderType {
    SOLID(RenderType.func_228639_c_(), VoxelType.SOLID),
    SOLID_FLUID(RenderType.func_228639_c_(), VoxelType.FLUID),
    CUTOUT(RenderType.func_228643_e_(), null),
    CUTOUT_MIPPED(RenderType.func_228641_d_(), null),
    TRANSLUCENT(RenderType.func_228645_f_(), null),
    TRANSLUCENT_FLUID(RenderType.func_228645_f_(), VoxelType.FLUID),
    TRIPWIRE(RenderType.func_241715_r_(), null);

    public final RenderType layer;
    public final VoxelType type;

    private ChiselRenderType(RenderType layer, VoxelType type) {
        this.layer = layer;
        this.type = type;
    }

    public boolean filter(VoxelBlob vb) {
        if (vb == null) {
            return false;
        }
        if (vb.filter(this.layer)) {
            if (this.type != null) {
                return vb.filterFluids(this.type == VoxelType.FLUID);
            }
            return true;
        }
        return false;
    }

    public static ChiselRenderType fromLayer(RenderType layerInfo, boolean isFluid) {
        if (layerInfo == null) {
            layerInfo = RenderType.func_228639_c_();
        }
        if (ChiselRenderType.CUTOUT.layer.equals((Object)layerInfo)) {
            return CUTOUT;
        }
        if (ChiselRenderType.CUTOUT_MIPPED.layer.equals((Object)layerInfo)) {
            return CUTOUT_MIPPED;
        }
        if (ChiselRenderType.SOLID.layer.equals((Object)layerInfo)) {
            return isFluid ? SOLID_FLUID : SOLID;
        }
        if (ChiselRenderType.TRANSLUCENT.layer.equals((Object)layerInfo)) {
            return isFluid ? TRANSLUCENT_FLUID : TRANSLUCENT;
        }
        if (ChiselRenderType.TRIPWIRE.layer.equals((Object)layerInfo)) {
            return TRIPWIRE;
        }
        throw new InvalidParameterException();
    }

    public ICullTest getTest() {
        return new MCCullTest();
    }
}

