/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import net.minecraft.util.Direction;

class FaceRegion {
    public final Direction face;
    final int blockStateID;
    final boolean isEdge;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public FaceRegion(Direction myFace, int centerX, int centerY, int centerZ, int blockStateID, boolean isEdgeFace) {
        this.face = myFace;
        this.blockStateID = blockStateID;
        this.isEdge = isEdgeFace;
        this.minX = centerX;
        this.minY = centerY;
        this.minZ = centerZ;
        this.maxX = centerX;
        this.maxY = centerY;
        this.maxZ = centerZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public boolean extend(FaceRegion currentFace) {
        if (currentFace.blockStateID != this.blockStateID) {
            return false;
        }
        switch (this.face) {
            case DOWN: 
            case UP: {
                boolean d;
                boolean a = this.maxX == currentFace.minX - 2 && this.maxZ == currentFace.maxZ && this.minZ == currentFace.minZ;
                boolean b = this.minX == currentFace.maxX + 2 && this.maxZ == currentFace.maxZ && this.minZ == currentFace.minZ;
                boolean c = this.maxZ == currentFace.minZ - 2 && this.maxX == currentFace.maxX && this.minX == currentFace.minX;
                boolean bl = d = this.minZ == currentFace.maxZ + 2 && this.maxX == currentFace.maxX && this.minX == currentFace.minX;
                if (a || b || c || d) {
                    this.minX = Math.min(currentFace.minX, this.minX);
                    this.minY = Math.min(currentFace.minY, this.minY);
                    this.minZ = Math.min(currentFace.minZ, this.minZ);
                    this.maxX = Math.max(currentFace.maxX, this.maxX);
                    this.maxY = Math.max(currentFace.maxY, this.maxY);
                    this.maxZ = Math.max(currentFace.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
            case WEST: 
            case EAST: {
                boolean d;
                boolean a = this.maxY == currentFace.minY - 2 && this.maxZ == currentFace.maxZ && this.minZ == currentFace.minZ;
                boolean b = this.minY == currentFace.maxY + 2 && this.maxZ == currentFace.maxZ && this.minZ == currentFace.minZ;
                boolean c = this.maxZ == currentFace.minZ - 2 && this.maxY == currentFace.maxY && this.minY == currentFace.minY;
                boolean bl = d = this.minZ == currentFace.maxZ + 2 && this.maxY == currentFace.maxY && this.minY == currentFace.minY;
                if (a || b || c || d) {
                    this.minX = Math.min(currentFace.minX, this.minX);
                    this.minY = Math.min(currentFace.minY, this.minY);
                    this.minZ = Math.min(currentFace.minZ, this.minZ);
                    this.maxX = Math.max(currentFace.maxX, this.maxX);
                    this.maxY = Math.max(currentFace.maxY, this.maxY);
                    this.maxZ = Math.max(currentFace.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
            case NORTH: 
            case SOUTH: {
                boolean d;
                boolean a = this.maxY == currentFace.minY - 2 && this.maxX == currentFace.maxX && this.minX == currentFace.minX;
                boolean b = this.minY == currentFace.maxY + 2 && this.maxX == currentFace.maxX && this.minX == currentFace.minX;
                boolean c = this.maxX == currentFace.minX - 2 && this.maxY == currentFace.maxY && this.minY == currentFace.minY;
                boolean bl = d = this.minX == currentFace.maxX + 2 && this.maxY == currentFace.maxY && this.minY == currentFace.minY;
                if (a || b || c || d) {
                    this.minX = Math.min(currentFace.minX, this.minX);
                    this.minY = Math.min(currentFace.minY, this.minY);
                    this.minZ = Math.min(currentFace.minZ, this.minZ);
                    this.maxX = Math.max(currentFace.maxX, this.maxX);
                    this.maxY = Math.max(currentFace.maxY, this.maxY);
                    this.maxZ = Math.max(currentFace.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

