/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BundledRedstone {
    private static final ArrayList<IBundledRedstoneProvider> providers = new ArrayList();

    private BundledRedstone() {
    }

    public static synchronized void register(@Nonnull IBundledRedstoneProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        if (!providers.contains(provider)) {
            providers.add(provider);
        }
    }

    public static int getDefaultOutput(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return World.func_175701_a((BlockPos)pos) ? DefaultBundledRedstoneProvider.getDefaultBundledRedstoneOutput(world, pos, side) : -1;
    }

    private static int getUnmaskedOutput(World world, BlockPos pos, Direction side) {
        if (!World.func_175701_a((BlockPos)pos)) {
            return -1;
        }
        int combinedSignal = -1;
        for (IBundledRedstoneProvider bundledRedstoneProvider : providers) {
            try {
                int signal = bundledRedstoneProvider.getBundledRedstoneOutput(world, pos, side);
                if (signal < 0) continue;
                combinedSignal = combinedSignal < 0 ? signal & 0xFFFF : combinedSignal | signal & 0xFFFF;
            }
            catch (Exception e) {
                ComputerCraft.log.error("Bundled redstone provider " + bundledRedstoneProvider + " errored.", (Throwable)e);
            }
        }
        return combinedSignal;
    }

    public static int getOutput(World world, BlockPos pos, Direction side) {
        int signal = BundledRedstone.getUnmaskedOutput(world, pos, side);
        return signal >= 0 ? signal : 0;
    }
}

