/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.item.ItemModFishBucket;
import dev.itsmeow.betteranimalsplus.imdlib.item.ModSpawnEggItem;
import dev.itsmeow.betteranimalsplus.imdlib.tileentity.TileEntityHead;
import dev.itsmeow.betteranimalsplus.imdlib.util.ClassLoadHacks;
import dev.itsmeow.betteranimalsplus.imdlib.util.HeadType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;

public class EntityRegistrarHandler {
    public final String modid;
    public final LinkedHashMap<String, EntityTypeContainer<? extends MobEntity>> ENTITIES = new LinkedHashMap();
    private static final Field SERIALIZABLE = ObfuscationReflectionHelper.findField(EntityType.class, (String)"field_200733_aL");
    public static boolean useAttributeEvents;

    public EntityRegistrarHandler(String modid) {
        this.modid = modid;
    }

    public void subscribe(IEventBus modBus) {
        modBus.register((Object)new EventHandler(this));
        ClassLoadHacks.runIf(useAttributeEvents, () -> () -> modBus.register((Object)new EntityAttributeRegistrar(this)));
    }

    public <T extends MobEntity> EntityTypeContainer<T> getEntityTypeContainer(String name) {
        return this.ENTITIES.get(name);
    }

    public <T extends MobEntity> EntityType<T> getEntityType(String name) {
        return this.ENTITIES.get(name).getEntityType();
    }

    public <T extends MobEntity> EntityTypeContainer<T> add(Class<T> entityClass, EntityType.IFactory<T> factory, String name, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, Function<EntityTypeContainer.Builder<T>, EntityTypeContainer.Builder<T>> transformer) {
        return this.add((IEntityBuilder)transformer.apply(EntityTypeContainer.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends MobEntity, I extends Item> EntityTypeContainerContainable<T, I> addContainable(Class<T> entityClass, EntityType.IFactory<T> factory, String name, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, Function<EntityTypeContainerContainable.Builder<T, I>, EntityTypeContainerContainable.Builder<T, I>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends MobEntity> EntityTypeContainerContainable<T, ItemModFishBucket<T>> addContainableB(Class<T> entityClass, EntityType.IFactory<T> factory, String name, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, Function<EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>, EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends MobEntity, C extends EntityTypeContainer<T>> C add(IEntityBuilder<T, C, ?> builder) {
        C c = builder.build();
        ((EntityTypeContainer)c).entityType = this.createEntityType((EntityTypeContainer<T>)c);
        ((EntityTypeContainer)c).onCreateEntityType();
        this.ENTITIES.put(((EntityTypeContainer)c).getEntityName(), (EntityTypeContainer<? extends MobEntity>)c);
        return c;
    }

    public <T extends MobEntity> EntityType<T> createEntityType(EntityTypeContainer<T> container) {
        return this.createEntityType(container.getDefinition().getEntityFactory(), container.getEntityName(), container.getDefinition().getSpawnClassification(), 64, 1, true, container.getWidth(), container.getHeight());
    }

    public <T extends Entity> EntityType<T> createEntityType(EntityType.IFactory<T> factory, String entityNameIn, EntityClassification classification, int trackingRange, int updateInterval, boolean velUpdates, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification).setTrackingRange(trackingRange).setUpdateInterval(updateInterval).setShouldReceiveVelocityUpdates(velUpdates).func_220321_a(width, height).func_200706_c().func_206830_a(this.modid + ":" + entityNameIn.toLowerCase());
        type.setRegistryName(this.modid + ":" + entityNameIn.toLowerCase());
        try {
            type.field_200733_aL = true;
        }
        catch (Exception e) {
            try {
                EntityRegistrarHandler.setFinalField(SERIALIZABLE, type, true);
            }
            catch (Exception e2) {
                LogManager.getLogger().error("Unable to set serializable for {}. This could result in possible saving issues with entities!", (Object)entityNameIn);
                e2.printStackTrace();
            }
        }
        return type;
    }

    private static void setFinalField(Field field, Object object, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(object, newValue);
    }

    public ServerEntityConfiguration serverConfig(ForgeConfigSpec.Builder builder) {
        return new ServerEntityConfiguration(builder);
    }

    public ClientEntityConfiguration clientConfig(ForgeConfigSpec.Builder builder) {
        return new ClientEntityConfiguration(builder);
    }

    static {
        try {
            Class.forName("net.minecraftforge.event.entity.EntityAttributeCreationEvent");
            useAttributeEvents = true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            useAttributeEvents = false;
        }
    }

    public class ClientEntityConfiguration {
        ClientEntityConfiguration(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"This is the CLIENT SIDE configuration for " + EntityRegistrarHandler.this.modid + ".", "To configure SERVER values (spawning, behavior, etc), go to:", "saves/(world)/serverconfig/" + EntityRegistrarHandler.this.modid + "-server.toml", "or, on a dedicated server:", "(world)/serverconfig/" + EntityRegistrarHandler.this.modid + "-server.toml"});
            builder.push("entities");
            EntityRegistrarHandler.this.ENTITIES.values().forEach(c -> c.clientCustomConfigurationInit(builder));
            builder.pop();
        }

        public void onLoad() {
            EntityRegistrarHandler.this.ENTITIES.values().forEach(EntityTypeContainer::clientCustomConfigurationLoad);
        }
    }

    public class ServerEntityConfiguration {
        ServerEntityConfiguration(ForgeConfigSpec.Builder builder) {
            builder.push("entities");
            EntityRegistrarHandler.this.ENTITIES.values().forEach(c -> c.createConfiguration(builder));
            builder.pop();
        }

        public void onLoad() {
            EntityRegistrarHandler.this.ENTITIES.values().forEach(e -> e.getConfiguration().load());
            if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
                MutableRegistry biomeRegistry = ServerLifecycleHooks.getCurrentServer().func_244267_aX().func_243612_b(Registry.field_239720_u_);
                for (ResourceLocation key : biomeRegistry.func_148742_b()) {
                    Biome biome = (Biome)biomeRegistry.func_241873_b(key).get();
                    MobSpawnInfo spawnInfo = biome.func_242433_b();
                    spawnInfo.field_242554_e = new HashMap(spawnInfo.field_242554_e);
                    for (EntityClassification classification : EntityClassification.values()) {
                        ArrayList newList = new ArrayList();
                        List oldList = (List)spawnInfo.field_242554_e.get(classification);
                        if (oldList != null) {
                            newList.addAll(oldList);
                        }
                        spawnInfo.field_242554_e.put(classification, newList);
                    }
                    spawnInfo.field_242555_f = new HashMap(spawnInfo.field_242555_f);
                    for (EntityTypeContainer entityTypeContainer : EntityRegistrarHandler.this.ENTITIES.values()) {
                        EntityTypeContainer.EntityConfiguration config = entityTypeContainer.getConfiguration();
                        if (!((Boolean)config.doSpawning.get()).booleanValue() || (Integer)config.spawnWeight.get() <= 0 || !entityTypeContainer.getBiomeIDs().contains(key.toString())) continue;
                        entityTypeContainer.registerPlacement();
                        List list = (List)spawnInfo.field_242554_e.get(entityTypeContainer.getDefinition().getSpawnClassification());
                        if (list != null) {
                            list.add(entityTypeContainer.getSpawnEntry());
                        }
                        if ((Double)config.spawnCostPer.get() == 0.0 || (Double)config.spawnMaxCost.get() == 0.0 || !entityTypeContainer.getSpawnCostBiomeIDs().contains(key.toString())) continue;
                        MobSpawnInfo.SpawnCosts costs = (MobSpawnInfo.SpawnCosts)new MobSpawnInfo.Builder().func_242573_a(entityTypeContainer.getEntityType(), (double)((Double)config.spawnCostPer.get()).doubleValue(), (double)((Double)config.spawnMaxCost.get()).doubleValue()).func_242577_b().field_242555_f.get(entityTypeContainer.getEntityType());
                        spawnInfo.field_242555_f.put(entityTypeContainer.getEntityType(), costs);
                    }
                }
            }
        }
    }

    public static class EntityAttributeRegistrar {
        private final EntityRegistrarHandler handler;

        public EntityAttributeRegistrar(EntityRegistrarHandler handler) {
            this.handler = handler;
        }

        @SubscribeEvent
        public void attributeCreate(EntityAttributeCreationEvent event) {
            for (EntityTypeContainer<? extends MobEntity> container : this.handler.ENTITIES.values()) {
                event.put(container.entityType, container.getAttributeBuilder().get().func_233813_a_());
            }
        }
    }

    public static class EventHandler {
        private final EntityRegistrarHandler handler;

        public EventHandler(EntityRegistrarHandler handler) {
            this.handler = handler;
        }

        @SubscribeEvent
        public void gatherData(GatherDataEvent event) {
            event.getGenerator().func_200390_a((IDataProvider)new ModSpawnEggItem.DataProvider(this.handler, event.getGenerator(), event.getExistingFileHelper()));
        }

        @SubscribeEvent
        public void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
            for (EntityTypeContainer<? extends MobEntity> container : this.handler.ENTITIES.values()) {
                event.getRegistry().register(container.entityType);
                if (useAttributeEvents) continue;
                container.registerAttributes();
            }
        }

        @SubscribeEvent
        public void registerBlocks(RegistryEvent.Register<Block> event) {
            for (HeadType type : HeadType.values()) {
                event.getRegistry().registerAll((IForgeRegistryEntry[])type.getBlockSet().toArray(new Block[0]));
            }
        }

        @SubscribeEvent
        public void registerItems(RegistryEvent.Register<Item> event) {
            for (HeadType headType : HeadType.values()) {
                event.getRegistry().registerAll((IForgeRegistryEntry[])headType.getItemSet().toArray(new Item[0]));
            }
            for (EntityTypeContainer entityTypeContainer : this.handler.ENTITIES.values()) {
                if (entityTypeContainer instanceof EntityTypeContainerContainable) {
                    EntityTypeContainerContainable c = (EntityTypeContainerContainable)entityTypeContainer;
                    if (!ForgeRegistries.ITEMS.containsValue(c.getContainerItem()) && this.handler.modid.equals(c.getContainerItem().getRegistryName().func_110624_b())) {
                        event.getRegistry().register(c.getContainerItem());
                    }
                    if (!ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)c.getEmptyContainerItem()) && this.handler.modid.equals(c.getEmptyContainerItem().getRegistryName().func_110624_b())) {
                        event.getRegistry().register((IForgeRegistryEntry)c.getEmptyContainerItem());
                    }
                }
                if (!entityTypeContainer.hasEgg()) continue;
                event.getRegistry().register((IForgeRegistryEntry)entityTypeContainer.egg);
            }
        }

        @SubscribeEvent
        public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            TileEntityHead.registerType(event, this.handler.modid);
        }
    }
}

