/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public abstract class BlockAnimalSkull
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING_EXCEPT_DOWN = DirectionProperty.func_196962_a((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP});
    public static final DirectionProperty TOP_FACING = DirectionProperty.func_196962_a((String)"top", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (Object)Direction.UP, (Object)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));

    public BlockAnimalSkull() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200947_a(SoundType.field_185851_d).func_200943_b(0.8f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING_EXCEPT_DOWN, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TOP_FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPES.get(state.func_177229_b((Property)FACING_EXCEPT_DOWN));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] directions;
        BlockState state = this.func_176223_P();
        BlockPos pos = context.func_195995_a();
        for (Direction dir : directions = context.func_196009_e()) {
            Direction direction = dir.func_176734_d();
            if (direction == Direction.DOWN) {
                return null;
            }
            if (direction == Direction.UP) {
                state = (BlockState)state.func_206870_a((Property)TOP_FACING, (Comparable)Direction.func_176733_a((double)context.func_195999_j().func_70079_am()));
            }
            state = (BlockState)state.func_206870_a((Property)FACING_EXCEPT_DOWN, (Comparable)direction);
            if (context.func_195991_k().func_180495_p(pos.func_177972_a(dir)).func_196953_a(context)) continue;
            return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING_EXCEPT_DOWN, BlockStateProperties.field_208198_y, TOP_FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING_EXCEPT_DOWN, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING_EXCEPT_DOWN)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING_EXCEPT_DOWN)));
    }
}

