/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.itsmeow.betteranimalsplus.imdlib.block.BlockGenericSkull;
import dev.itsmeow.betteranimalsplus.imdlib.tileentity.TileEntityHead;
import dev.itsmeow.betteranimalsplus.imdlib.util.HeadType;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderGenericHead
extends TileEntityRenderer<TileEntityHead> {
    public static HashMap<HeadType, EntityModel<?>> modelMap = new HashMap();

    public RenderGenericHead(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityHead te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = te.func_195044_w();
        if (!(state.func_177230_c() instanceof BlockGenericSkull)) {
            return;
        }
        Direction dir = te.getDirection();
        dir = dir == null ? Direction.NORTH : dir;
        float rotation = -dir.func_185119_l();
        rotation = dir == Direction.NORTH || dir == Direction.SOUTH ? dir.func_176734_d().func_185119_l() : rotation;
        rotation = dir == Direction.UP ? te.getTopRotation() : rotation;
        Object model = modelMap.get(te.getHeadType());
        if (model == null) {
            EntityModel<? extends Entity> newModel = te.getNewModel();
            modelMap.put(te.getHeadType(), newModel);
            model = newModel;
        }
        this.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, dir, rotation, te.getTexture(), (EntityModel<? extends Entity>)model, te.getOffset());
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn, @Nullable Direction facing, float skullRotation, ResourceLocation texture, EntityModel<? extends Entity> model, float yOffset) {
        matrixStackIn.func_227860_a_();
        RenderGenericHead.translateHead(matrixStackIn, facing, 1.5f + yOffset);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        float rotX = 0.0f;
        if (facing != null) {
            rotX = facing == Direction.UP ? -90.0f : 0.0f;
        }
        model.func_225597_a_(null, skullRotation, rotX, 0.0f, 0.0f, 0.0f);
        model.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)texture)), packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    private static void translateHead(MatrixStack matrixStackIn, Direction face, float yOffset) {
        if (face == null) {
            matrixStackIn.func_227861_a_(0.5, (double)(0.25f + yOffset + 0.3f), 1.0);
            return;
        }
        switch (face) {
            case NORTH: {
                matrixStackIn.func_227861_a_(0.5, (double)(0.25f + yOffset + 0.3f), 1.0);
                break;
            }
            case EAST: {
                matrixStackIn.func_227861_a_(0.0, (double)(0.25f + yOffset + 0.3f), 0.5);
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227861_a_(0.5, (double)(0.25f + yOffset + 0.3f), 0.0);
                break;
            }
            case WEST: {
                matrixStackIn.func_227861_a_(1.0, (double)(0.25f + yOffset + 0.3f), 0.5);
                break;
            }
            case UP: {
                matrixStackIn.func_227861_a_(0.5, (double)(0.18f + yOffset), 0.5);
                break;
            }
            default: {
                matrixStackIn.func_227861_a_(0.0, (double)(0.25f + yOffset), 0.0);
            }
        }
    }
}

