/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.util.BiomeListBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.util.HeadType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;

public abstract class AbstractEntityBuilder<T extends MobEntity, C extends EntityTypeContainer<T>, B extends AbstractEntityBuilder<T, C, B>>
implements IEntityBuilder<T, C, B> {
    protected final Class<T> entityClass;
    protected final String entityName;
    protected final EntityType.IFactory<T> factory;
    public boolean hasSpawns;
    protected EntityClassification spawnType;
    protected int eggColorSolid;
    protected int eggColorSpot;
    protected int spawnWeight;
    protected boolean useSpawnCosts;
    protected int spawnMinGroup;
    protected int spawnMaxGroup;
    protected double spawnCostPer;
    protected double spawnMaxCost;
    protected float width;
    protected float height;
    protected boolean despawn;
    protected EntityTypeContainer.CustomConfigurationLoad customConfigLoad;
    protected EntityTypeContainer.CustomConfigurationInit customConfigInit;
    protected EntityTypeContainer.CustomConfigurationLoad customClientConfigLoad;
    protected EntityTypeContainer.CustomConfigurationInit customClientConfigInit;
    protected Supplier<Set<RegistryKey<Biome>>> defaultBiomeSupplier;
    protected EntitySpawnPlacementRegistry.PlacementType placementType;
    protected Heightmap.Type heightMapType;
    protected EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate;
    protected int variantCount = 0;
    protected IVariant[] variants;
    protected final String modid;
    protected boolean hasEgg;
    protected final Supplier<AttributeModifierMap.MutableAttribute> attributeMap;
    protected Function<C, HeadType> headTypeBuilder;

    protected AbstractEntityBuilder(Class<T> EntityClass, EntityType.IFactory<T> factory, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
        this.entityClass = EntityClass;
        this.factory = factory;
        this.entityName = entityNameIn;
        this.modid = modid;
        this.eggColorSolid = 0;
        this.eggColorSpot = 0xFFFFFF;
        this.spawnWeight = 1;
        this.spawnMinGroup = 1;
        this.spawnMaxGroup = 1;
        this.useSpawnCosts = false;
        this.spawnCostPer = 1.0;
        this.spawnMaxCost = 10.0;
        this.spawnType = EntityClassification.CREATURE;
        this.hasSpawns = false;
        this.width = 1.0f;
        this.height = 1.0f;
        this.despawn = false;
        this.hasEgg = false;
        this.defaultBiomeSupplier = HashSet::new;
        this.placementType = null;
        this.heightMapType = null;
        this.placementPredicate = null;
        this.attributeMap = attributeMap;
    }

    public abstract B getImplementation();

    @Override
    public B spawn(EntityClassification type, int weight, int min, int max) {
        this.hasSpawns = true;
        this.spawnType = type;
        this.spawnWeight = weight;
        this.spawnMinGroup = min;
        this.spawnMaxGroup = max;
        return this.getImplementation();
    }

    @Override
    public B spawnCosts(double cost, double maxCost) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before spawn costs");
        }
        this.useSpawnCosts = true;
        this.spawnCostPer = cost;
        this.spawnMaxCost = maxCost;
        return this.getImplementation();
    }

    @Override
    public B egg(int solid, int spot) {
        this.hasEgg = true;
        this.eggColorSolid = solid;
        this.eggColorSpot = spot;
        return this.getImplementation();
    }

    @Override
    public B size(float width, float height) {
        this.width = width;
        this.height = height;
        return this.getImplementation();
    }

    @Override
    public B despawn() {
        this.despawn = true;
        return this.getImplementation();
    }

    @Override
    public B config(EntityTypeContainer.CustomConfigurationInit configurationInit) {
        return (B)this.config(configurationInit, holder -> {});
    }

    @Override
    public B clientConfig(EntityTypeContainer.CustomConfigurationInit configurationInit) {
        return (B)this.clientConfig(configurationInit, holder -> {});
    }

    @Override
    public B config(EntityTypeContainer.CustomConfigurationInit configurationInit, EntityTypeContainer.CustomConfigurationLoad configurationLoad) {
        this.customConfigLoad = configurationLoad;
        this.customConfigInit = configurationInit;
        return this.getImplementation();
    }

    @Override
    public B clientConfig(EntityTypeContainer.CustomConfigurationInit configurationInit, EntityTypeContainer.CustomConfigurationLoad configurationLoad) {
        this.customClientConfigLoad = configurationLoad;
        this.customClientConfigInit = configurationInit;
        return this.getImplementation();
    }

    @Override
    public B placement(EntitySpawnPlacementRegistry.PlacementType type, Heightmap.Type heightMap, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before placement");
        }
        this.placementType = type;
        this.heightMapType = heightMap;
        this.placementPredicate = predicate;
        return this.getImplementation();
    }

    @Override
    public B defaultPlacement(EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        return (B)this.placement(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (EntitySpawnPlacementRegistry.IPlacementPredicate)predicate);
    }

    @Override
    public B waterPlacement() {
        return (B)this.placement(EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityTypeContainer::waterSpawn);
    }

    @Override
    public B waterPlacement(EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        return (B)this.placement(EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (EntitySpawnPlacementRegistry.IPlacementPredicate)predicate);
    }

    @Override
    public B biomes(BiomeDictionary.Type ... biomeTypes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = AbstractEntityBuilder.toBiomes(biomeTypes, false);
        return this.getImplementation();
    }

    @Override
    public B biomesOverworld(BiomeDictionary.Type ... biomeTypes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = AbstractEntityBuilder.toBiomes(biomeTypes, true);
        return this.getImplementation();
    }

    @Override
    public B biomes(Supplier<RegistryKey<Biome>[]> biomes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = () -> Sets.newHashSet((Object[])((Object[])biomes.get()));
        return this.getImplementation();
    }

    @Override
    public B biomes(Function<BiomeListBuilder, BiomeListBuilder> biomes) {
        return (B)this.biomes(biomes.apply(BiomeListBuilder.create())::collect);
    }

    @Override
    public B variants(IVariant ... variants) {
        this.variantCount = variants.length;
        this.variants = variants;
        return this.getImplementation();
    }

    @Override
    public B variants(String ... nameTextures) {
        this.variantCount = nameTextures.length;
        this.variants = new EntityVariant[nameTextures.length];
        for (int i = 0; i < nameTextures.length; ++i) {
            String nameTex = nameTextures[i];
            this.variants[i] = new EntityVariant(this.modid, nameTex, this.entityName + "_" + nameTex);
        }
        return this.getImplementation();
    }

    @Override
    public B variants(int max) {
        if (max > 0) {
            this.variantCount = max;
            this.variants = new EntityVariant[max];
            for (int i = 0; i < max; ++i) {
                String nameTex = String.valueOf(i + 1);
                this.variants[i] = new EntityVariant(this.modid, nameTex, this.entityName + "_" + nameTex);
            }
        } else {
            throw new RuntimeException("what are you doing kid");
        }
        return this.getImplementation();
    }

    @Override
    public B variants(Function<String, IVariant> constructor, String ... variants) {
        this.variantCount = variants.length;
        IVariant[] variantList = new IVariant[this.variantCount];
        for (int i = 0; i < this.variantCount; ++i) {
            variantList[i] = constructor.apply(variants[i]);
        }
        this.variants = variantList;
        return this.getImplementation();
    }

    protected static Supplier<Set<RegistryKey<Biome>>> toBiomes(BiomeDictionary.Type[] biomeTypes, boolean overworldOnly) {
        return () -> Lists.newArrayList((Object[])biomeTypes).stream().flatMap(type -> BiomeDictionary.getBiomes((BiomeDictionary.Type)type).stream()).filter(b -> !overworldOnly || BiomeDictionary.hasType((RegistryKey)b, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD)).collect(Collectors.toSet());
    }

    @Override
    public HeadType.Builder<T, C, B> head(String headName) {
        return new HeadType.Builder(this.getImplementation(), headName);
    }

    @Override
    public HeadType.Builder<T, C, B> head() {
        return this.head(this.entityName + "head");
    }

    @Override
    public void postBuild(C container) {
        if (this.headTypeBuilder != null) {
            ((EntityTypeContainer)container).setHeadType(this.headTypeBuilder.apply(container));
        }
    }

    @Override
    public void setHeadBuild(Function<C, HeadType> builder) {
        this.headTypeBuilder = builder;
    }

    @Override
    public String getMod() {
        return this.modid;
    }
}

