/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraftforge.fluids.FluidStack;

public class SulfurRecoveryRecipeBuilder
extends IEFinishedRecipe<SulfurRecoveryRecipeBuilder> {
    public static SulfurRecoveryRecipeBuilder builder(FluidStack fluidOutput, int energy, int time) {
        return new SulfurRecoveryRecipeBuilder().setTimeAndEnergy(time, energy).addResultFluid(fluidOutput);
    }

    protected SulfurRecoveryRecipeBuilder() {
        super((IERecipeSerializer)Serializers.HYDROTREATER_SERIALIZER.get());
    }

    public SulfurRecoveryRecipeBuilder addResultFluid(FluidStack fluid) {
        return (SulfurRecoveryRecipeBuilder)this.addFluid("result", fluid);
    }

    public SulfurRecoveryRecipeBuilder addInputFluid(FluidStack fluid) {
        return (SulfurRecoveryRecipeBuilder)this.addFluid("input", fluid);
    }

    public SulfurRecoveryRecipeBuilder addInputFluid(FluidTagInput fluid) {
        return (SulfurRecoveryRecipeBuilder)this.addFluidTag("input", fluid);
    }

    public SulfurRecoveryRecipeBuilder addInputFluid(ITag.INamedTag<Fluid> fluid, int amount) {
        return (SulfurRecoveryRecipeBuilder)this.addFluidTag("input", fluid, amount);
    }

    public SulfurRecoveryRecipeBuilder addSecondaryInputFluid(FluidStack fluid) {
        return (SulfurRecoveryRecipeBuilder)this.addFluid("secondary_input", fluid);
    }

    public SulfurRecoveryRecipeBuilder addSecondaryInputFluid(FluidTagInput fluid) {
        return (SulfurRecoveryRecipeBuilder)this.addFluidTag("secondary_input", fluid);
    }

    public SulfurRecoveryRecipeBuilder addSecondaryInputFluid(ITag.INamedTag<Fluid> fluid, int amount) {
        return (SulfurRecoveryRecipeBuilder)this.addFluidTag("secondary_input", fluid, amount);
    }

    public SulfurRecoveryRecipeBuilder addItemWithChance(ItemStack item, double chance) {
        return (SulfurRecoveryRecipeBuilder)this.addWriter(jsonObject -> jsonObject.add("secondary_result", (JsonElement)this.serializerItemStackWithChance(item, chance)));
    }

    protected SulfurRecoveryRecipeBuilder setTimeAndEnergy(int time, int energy) {
        return (SulfurRecoveryRecipeBuilder)((SulfurRecoveryRecipeBuilder)this.setTime(time)).setEnergy(energy);
    }

    protected JsonObject serializerItemStackWithChance(ItemStack stack, double chance) {
        JsonObject itemJson = this.serializeItemStack(stack);
        itemJson.addProperty("chance", Double.toString(chance));
        return itemJson;
    }
}

